<?php
 
add_action( 'pxl_post_metabox_register', 'aimo_page_options_register' );
function aimo_page_options_register( $metabox ) {
 
	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Options', 'aimo' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_settings' => [
					'title'  => esc_html__( 'Post Options', 'aimo' ),
					'icon'   => 'el el-cog',
					'fields' => array_merge(
						aimo_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						array(
							array(	
								'id'	=> 'type_post_feature',
								'type'	=> 'button_set',
								'title' => esc_html__('Post Feature', 'aimo'),
								'options'	=>  array(
									'default'	=> esc_html__('Default','aimo'),
									'video_link'=> esc_html__('Video','aimo'),
									'image_swiper'	=> esc_html__('Image Swiper','aimo'),
								),
								'default'	=> 'default',	
							),
							array(
								'id'=> 'post_video_link',
								'type' => 'text',
								'title' => esc_html__('Video Link', 'aimo'),
								'validate' => 'url',
								'default' => '',
								'indent' => true,
								'required' => array( 0 => 'type_post_feature', 1 => 'equals', 2 => 'video_link' ),
							),
							array(
								'id'       => 'post_images',
								'type'     => 'gallery',
								'title'    => esc_html__('Images', 'aimo'),
								'default'  => array(),
								'url'      => false,
								'indent' => true,
								'required' => array( 0 => 'type_post_feature', 1 => 'equals', 2 => 'image_swiper' ),
							),
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'aimo' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
					    )
					)
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'aimo' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        aimo_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
					            'id' => 'custom_ptitle',
					            'type' => 'text',
					            'title' => esc_html__('Custom Page Title', 'aimo'),
					        ),
					    )
				    )
				],
				'header' => [
					'title'  => esc_html__( 'Header', 'aimo' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        aimo_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						aimo_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'aimo'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'aimo'),
				                    'hide'  => esc_html__('Hide', 'aimo'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				                'id'       => 'page_mobile_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Mobile Style', 'aimo'),
				                'options'  => array(
				                    'inherit'  => esc_html__('Inherit', 'aimo'),
				                    'light'  => esc_html__('Light', 'aimo'),
				                    'dark'  => esc_html__('Dark', 'aimo'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo Dark', 'aimo'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				           		'id'       => 'logo_light_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo Light', 'aimo'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'aimo' ),
				                'options'  => aimo_get_nav_menu_slug(),
				                'default' => '',
				                'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'aimo'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'aimo'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'aimo'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'aimo'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'aimo'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Options', 'aimo' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'aimo' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        aimo_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						aimo_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'aimo'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'aimo'),
				                    'hide'  => esc_html__('Hide', 'aimo'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				                'id'       => 'page_mobile_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Mobile Style', 'aimo'),
				                'options'  => array(
				                    'inherit'  => esc_html__('Inherit', 'aimo'),
				                    'light'  => esc_html__('Light', 'aimo'),
				                    'dark'  => esc_html__('Dark', 'aimo'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo Dark', 'aimo'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				           		'id'       => 'logo_light_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo Light', 'aimo'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'aimo' ),
				                'options'  => aimo_get_nav_menu_slug(),
				                'default' => '',
				                'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'aimo'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'aimo'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'aimo'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'aimo'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'aimo'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        ),
						
				    )
					 
				],
				
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'aimo' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        aimo_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
				
				'content' => [
					'title'  => esc_html__( 'Content', 'aimo' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						aimo_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'aimo' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'aimo' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        aimo_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'aimo'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'aimo'),
				                    'hide'  => esc_html__('Hide', 'aimo'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'aimo'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'aimo'),
				                    'on' => esc_html__('On', 'aimo'),
				                    'off' => esc_html__('Off', 'aimo'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				                'id'       => 'back_top_top_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Back to Top Style', 'aimo'),
				                'options'  => array(
				                    'style-default' => esc_html__('Default', 'aimo'),
				                    'style-round' => esc_html__('Round', 'aimo'),
				                ),
				                'default'  => 'style-default',
				            ),
						)
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'aimo' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
							    'id'        => 'page_body_color',
							    'type'      => 'color',
							    'title'     => esc_html__('Body Background Color', 'aimo'),
							    'default'   => '',
							    'transparent' => false,
							    'output'    => array(
							        'background-color' => 'body',
							    )
							),
				        	array(
					            'id'          => 'primary_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Primary Color', 'aimo'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					        array(
					            'id'          => 'gradient_color',
					            'type'        => 'color_gradient',
					            'title'       => esc_html__('Gradient Color', 'aimo'),
					            'transparent' => false,
					            'default'  => array(
					                'from' => '',
					                'to'   => '', 
					            ),
					        ),
					    )
				    )
				],
				'extra' => [
					'title'  => esc_html__( 'Extra', 'aimo' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id' => 'body_custom_class',
					            'type' => 'text',
					            'title' => esc_html__('Body Custom Class', 'aimo'),
					        ),
					    )
				    )
				]
			]
		],
		'portfolio' => [
			'opt_name'            => 'pxl_portfolio_options',
			'display_name'        => esc_html__( 'Portfolio Options', 'aimo' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'aimo' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
					            'id'=> 'portfolio_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'aimo'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'aimo' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
				    )
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'aimo' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        aimo_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
					            'id' => 'custom_ptitle',
					            'type' => 'text',
					            'title' => esc_html__('Custom Page Title', 'aimo'),
					        ),
					    )
				    )
				]
			]
		],
		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service Options', 'aimo' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'general' => [
					'title'  => esc_html__( 'General', 'aimo' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						
						array(
							array(
					            'id'=> 'service_external_link',
					            'type' => 'text',
					            'title' => esc_html__('External Link', 'aimo'),
					            'validate' => 'url',
					            'default' => '',
					        ),
							array(
					            'id'=> 'service_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'aimo'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
					            'id'       => 'service_icon_type',
					            'type'     => 'button_set',
					            'title'    => esc_html__('Icon Type', 'aimo'),
					            'options'  => array(
					                'icon'  => esc_html__('Icon', 'aimo'),
					                'image'  => esc_html__('Image', 'aimo'),
					            ),
					            'default'  => 'icon'
					        ),
					        array(
					            'id'       => 'service_icon_font',
					            'type'     => 'pxl_iconpicker',
					            'title'    => esc_html__('Icon', 'aimo'),
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
            					'force_output' => true
					        ),
					        array(
					            'id'       => 'service_icon_img',
					            'type'     => 'media',
					            'title'    => esc_html__('Icon Image', 'aimo'),
					            'default' => '',
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
				            	'force_output' => true
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'aimo' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						),
						aimo_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'header' => [
					'title'  => esc_html__( 'Header', 'aimo' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        aimo_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						aimo_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'aimo'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'aimo'),
				                    'hide'  => esc_html__('Hide', 'aimo'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				                'id'       => 'page_mobile_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Mobile Style', 'aimo'),
				                'options'  => array(
				                    'inherit'  => esc_html__('Inherit', 'aimo'),
				                    'light'  => esc_html__('Light', 'aimo'),
				                    'dark'  => esc_html__('Dark', 'aimo'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo Dark', 'aimo'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				           		'id'       => 'logo_light_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo Light', 'aimo'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'aimo' ),
				                'options'  => aimo_get_nav_menu_slug(),
				                'default' => '',
				                'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'aimo'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'aimo'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'aimo'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'aimo'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'aimo'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'aimo' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        aimo_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
					            'id' => 'custom_ptitle',
					            'type' => 'text',
					            'title' => esc_html__('Custom Page Title', 'aimo'),
					        ),
					    )
				    )
				]
			]
		],

		'career' => [
			'opt_name'            => 'pxl_career_options',
			'display_name'        => esc_html__( 'Career Options', 'aimo' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'aimo' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						aimo_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
					            'id'=> 'career_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'aimo'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'aimo' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
								'id'=>'custom_career_title_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Title For Career', 'aimo'),
							),
							array(
								'id'=>'button_text',
								'type' => 'text',
								'title'    => esc_html__('Custom button text For Career', 'aimo'),
							),
						)
				    )
				],
				'career_page_title' => [
					'title'  => esc_html__( 'Career Page Title', 'aimo' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        aimo_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],



		'pxl-template' => [ //post_type
			'opt_name'            => 'pxl_hidden_template_options',
			'display_name'        => esc_html__( 'Template Options', 'aimo' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'aimo' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'aimo'),
				            'options' => [
				            	'df'       	   => esc_html__('Select Type', 'aimo'), 
								'header'       => esc_html__('Header Desktop', 'aimo'),
								'header-mobile'       => esc_html__('Header Mobile', 'aimo'),
								'footer'       => esc_html__('Footer', 'aimo'), 
								'mega-menu'    => esc_html__('Mega Menu', 'aimo'), 
								'page-title'   => esc_html__('Page Title', 'aimo'), 
								'tab' => esc_html__('Tab', 'aimo'),
								'hidden-panel' => esc_html__('Hidden Panel', 'aimo'),
								'popup' => esc_html__('Popup', 'aimo'),
								'page' => esc_html__('Page', 'aimo'),
								'slider' => esc_html__('Slider', 'aimo'),
				            ],
				            'default' => 'df',
				        ),
				        array(
							'id'    => 'header_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'aimo'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'aimo'), 
								'px-header--transparent'       => esc_html__('Transparent', 'aimo'),
								'px-header--left_sidebar'       => esc_html__('Left Sidebar', 'aimo'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
				        ),

				        array(
							'id'    => 'header_mobile_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'aimo'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'aimo'), 
								'px-header--transparent'       => esc_html__('Transparent', 'aimo'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header-mobile' ),
				        ),

				        array(
							'id'    => 'hidden_panel_position',
							'type'  => 'select',
							'title' => esc_html__('Hidden Panel Position', 'aimo'),
				            'options' => [
				            	'top'       	   => esc_html__('Top', 'aimo'),
				            	'right'       	   => esc_html__('Right', 'aimo'),
				            ],
				            'default' => 'right',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_height',
				            'type'        => 'text',
				            'title'       => esc_html__('Hidden Panel Height', 'aimo'),
				            'subtitle'       => esc_html__('Enter number.', 'aimo'),
				            'transparent' => false,
				            'default'     => '',
				            'force_output' => true,
				            'required' => array( 0 => 'hidden_panel_position', 1 => 'equals', 2 => 'top' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_boxcolor',
				            'type'        => 'color',
				            'title'       => esc_html__('Box Color', 'aimo'),
				            'transparent' => false,
				            'default'     => '',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'header_sidebar_width',
				            'type'        => 'slider',
				            'title'       => esc_html__('Header Sidebar Width', 'aimo'),
				            "default"   => 300,
						    "min"       => 50,
						    "step"      => 1,
						    "max"       => 900,
				            'force_output' => true,
				            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
				        ),

				        array(
							'id'    => 'header_sidebar_style',
							'type'  => 'select',
							'title' => esc_html__('Header Sidebar Style', 'aimo'),
				            'options' => [
				            	'px-header-sidebar-style1'      => esc_html__('Style 1', 'aimo'), 
								'px-header-sidebar-style2'      => esc_html__('Style 2', 'aimo'),
				            ],
				            'default' => 'px-header-sidebar-style1',
				            'indent' => true,
                			'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
				        ),
					),
				    
				],
			]
		],
	];
 
	$metabox->add_meta_data( $panels );
}
 