<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Case-Themes
 */
$post_tag = aimo()->get_theme_opt( 'post_tag', true );
$post_navigation = aimo()->get_theme_opt( 'post_navigation', false );
$post_social_share = aimo()->get_theme_opt( 'post_social_share', false );
$tags_list = get_the_tag_list();
$sg_post_title = aimo()->get_theme_opt('sg_post_title', 'default');
$sg_post_title_ = aimo()->get_theme_opt('sg_post_title_', 'default');
$sg_featured_img_size = aimo()->get_theme_opt('sg_featured_img_size', '1170x580');
$post_video_link = get_post_meta(get_the_ID(), 'post_video_link', true);
$sg_post_featured = aimo()->get_theme_opt('sg_post_featured', 'default');
$sg_post_button = aimo()->get_theme_opt('sg_post_button', 'default');
$sg_button_link = aimo()->get_theme_opt('sg_button_link', 'default');
$sg_button_text = aimo()->get_theme_opt('sg_button_text', 'default');
?>
<article id="pxl-post-<?php the_ID(); ?>" <?php post_class('pxl---post'); ?>>
    <?php if(is_singular('post') && $sg_post_title_ == 'custom_text') { ?>
        <h2 class="pxl-item--title">
            <?php the_title(); ?>
        </h2>
    <?php } ?>
    <?php aimo()->blog->get_post_metas(); ?>
    <?php if(is_singular('post') && $sg_post_button == 'on') { ?>
        <div class="btn btn-icon-box4">
            <a href="<?php echo esc_url($sg_button_link); ?>">
                <?php echo esc_html($sg_button_text); ?>
                <span class="pxl--btn-icon">
                    <i aria-hidden="true" class="flaticon flaticon-next"></i>                            
                </span>
            </a>
        </div>
    <?php } ?>
    <?php if(is_singular('post') && $sg_post_featured == 'on') { ?>
        <?php if (has_post_thumbnail()) {
            $img  = pxl_get_image_by_size( array(
                'attach_id'  => get_post_thumbnail_id($post->ID),
                'thumb_size' => $sg_featured_img_size,
            ) );
            $thumbnail    = $img['thumbnail']; ?>
            <div class="pxl-item--image">
                <?php echo wp_kses_post($thumbnail); ?>
                       
            </div>
        <?php } ?>
    <?php } ?>

    <div class="pxl-item--content clearfix">
        <?php
            the_content();
            wp_link_pages( array(
                'before'      => '<div class="page-links">',
                'after'       => '</div>',
                'link_before' => '<span>',
                'link_after'  => '</span>',
            ) );
        ?>
    </div>

    <?php if($post_tag && $tags_list || $post_social_share ) :  ?>
        <div class="pxl--post-footer">
            <?php if($post_tag) { aimo()->blog->get_tagged_in(); } ?>
            <?php if($post_social_share) { aimo()->blog->get_socials_share(); } ?>
        </div>
    <?php endif; ?>
    <?php if($post_navigation) { aimo()->blog->get_post_nav(); } ?>
</article><!-- #post -->