<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Arcdeco Projects Carousel Widgets.
 *
 * @since 1.0
 */
class Arcdeco_Projects_Carousel_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-projects-carousel';
	}

	public function get_title() {
		return esc_html__( 'Projects Carousel', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return 'fas fa-arrows-alt-h';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Carousel', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label_block' => true,
				'label' => esc_html__( 'Name', 'arcdeco-plugin' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Enter name', 'arcdeco-plugin' ),
				'placeholder' => esc_html__( 'Enter name', 'arcdeco-plugin' ),
			]
		);

		$repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'arcdeco-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'URL', 'arcdeco-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'arcdeco-plugin' ),
				'type' => Controls_Manager::REPEATER,  
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);

		$this->end_controls_section();

	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() { 
		$settings = $this->get_settings_for_display(); ?>

		<!-- Slider -->
		<div class="project-slider project-slider-control-horizon swiper-container cursorDrag">
            <?php if ( $settings['items'] ) : ?>
            <div class="swiper-wrapper">
			    <?php foreach ( $settings['items'] as $item ) : 
			    	if ( $item['image'] ) : 
			    ?>
			    <!-- Item -->
			    <figure class="project-slider__item swiper-slide">
				    <div class="reveal-box">
				    	<?php
				    	$image = wp_get_attachment_image_url( $item['image']['id'], 'arcdeco_1920xAuto' );
				    	?>
					    <a<?php if ( $item['link'] ) : if ( $item['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $item['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $item['link']['url'] ); ?>"<?php endif; ?>>
						    <img class="cover lazyload" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $item['name'] ); ?>" />
						</a>
					    <span class="reveal-overlay"></span>
					</div>
				</figure>
			    <!-- /Item -->
				<?php endif; endforeach; ?>
		    </div>
			
			<!-- Control -->
		    <div class="slider__control slider__control__control-horizon">
			    <div class="slider-pagination-progressbar slider-pagination-progressbar-horizon"></div>
		    </div>
		    <div class="swiper-button-prev"></div>
			<div class="swiper-button-next"></div>
		    <?php endif; ?>
		</div>

		<?php 
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template() { ?>

		<!-- Slider -->
		<div class="project-slider project-slider-control-horizon swiper-container cursorDrag">
           <# if ( settings.items ) { #>
            <div class="swiper-wrapper">
			    <# _.each( settings.items, function( item ) { #>
			    <!-- Item -->
			    <figure class="project-slider__item swiper-slide">
				    <div class="reveal-box">
					    <a<# if ( item.link ) { #><# if ( item.link.is_external ) { #> target="_blank"<# } #><# if ( item.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ item.link.url }}}"<# } #>>
						    <img class="cover lazyload" src="{{{ item.image.url }}}" alt="{{{ item.name }}}" />
						</a>
					    <span class="reveal-overlay"></span>
					</div>
				</figure>
			    <!-- /Item -->
				<# }); #>
		    </div>
			
			<!-- Control -->
		    <div class="slider__control slider__control__control-horizon">
			    <div class="slider-pagination-progressbar slider-pagination-progressbar-horizon"></div>
		    </div>
		    <div class="swiper-button-prev"></div>
			<div class="swiper-button-next"></div>
		    <# } #>
		</div>

	<?php }
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_Projects_Carousel_Widget() );