<?php

/**
 * Register Custom Post Type: Portfolio
 */

function arcdeco_register_portfolio() {
	register_post_type( 'portfolio', array(
			'label' => esc_html__( 'Portfolio', 'arcdeco-plugin' ),
	        'description' => esc_html__( 'Portfolio', 'arcdeco-plugin' ),
	        'supports' => array( 'title','editor','revisions','thumbnail','page-attributes' ),
	        'taxonomies' => array( 'portfolio_categories' ),
	        'hierarchical' => false,
	        'show_in_rest' => true,
	        'public' => true,
	        'show_ui' => true,
	        'show_in_menu' => true,
	        'show_in_nav_menus' => true,
	        'show_in_admin_bar' => true,
	        'menu_position' => 20,
	        'menu_icon' => 'dashicons-images-alt2',
	        'can_export' => true,
	        'has_archive' => false,
	        'exclude_from_search' => false,
	        'publicly_queryable' => true,
	        'capability_type' => 'post',
	        'rewrite' => array( 'slug' => 'portfolio/item', 'with_front' => true  ),
			'labels' => array(
				'name' => esc_html__( 'Portfolio', 'arcdeco-plugin' ),
		        'singular_name' => esc_html__( 'Portfolio', 'arcdeco-plugin' ),
		        'menu_name' => esc_html__( 'Portfolio', 'arcdeco-plugin' ),
		        'parent_item_colon' => esc_html__( 'Parent Portfolio:', 'arcdeco-plugin' ),
		        'all_items' => esc_html__( 'All Portfolio', 'arcdeco-plugin' ),
		        'view_item' => esc_html__( 'View Portfolio', 'arcdeco-plugin' ),
		        'add_new_item' => esc_html__( 'Add New Portfolio', 'arcdeco-plugin' ),
		        'add_new' => esc_html__( 'New Portfolio', 'arcdeco-plugin' ),
		        'edit_item' => esc_html__( 'Edit Portfolio', 'arcdeco-plugin' ),
		        'update_item' => esc_html__( 'Update Portfolio', 'arcdeco-plugin' ),
		        'search_items' => esc_html__( 'Search Portfolio', 'arcdeco-plugin' ),
		        'not_found' => esc_html__( 'No portfolio found', 'arcdeco-plugin' ),
		        'not_found_in_trash' => esc_html__( 'No portfolio found in Trash', 'arcdeco-plugin' ),
			),
		)
	);
}
add_action( 'init', 'arcdeco_register_portfolio' );

function arcdeco_register_portfolio_categories() {
	register_taxonomy( 'portfolio_categories', array ( 0 => 'portfolio' ),
		array(
			'label' => esc_html__( 'Portfolio Categories', 'arcdeco-plugin' ),
			'hierarchical' => true,
			'show_ui' => true,
			'show_in_rest' => true,
			'show_admin_column' => true,
			'query_var' => true,
			'has_archive' => true,
			'rewrite' => array( 'slug' => 'portfolio-categories' ),
			'labels' => array(
				'name'              => esc_html__( 'Portfolio Categories', 'arcdeco-plugin' ),
		        'singular_name'     => esc_html__( 'Portfolio Categories', 'arcdeco-plugin' ),
		        'search_items'      => esc_html__( 'Search Portfolio Category', 'arcdeco-plugin' ),
		        'all_items'         => esc_html__( 'All Portfolio Category', 'arcdeco-plugin' ),
		        'parent_item'       => esc_html__( 'Parent Portfolio Category', 'arcdeco-plugin' ),
		        'parent_item_colon' => esc_html__( 'Parent Portfolio Category:', 'arcdeco-plugin' ),
		        'edit_item'         => esc_html__( 'Edit Portfolio Category', 'arcdeco-plugin' ),
		        'update_item'       => esc_html__( 'Update Portfolio Category', 'arcdeco-plugin' ),
		        'add_new_item'      => esc_html__( 'Add New Portfolio Category', 'arcdeco-plugin' ),
		        'new_item_name'     => esc_html__( 'New Portfolio Category Name', 'arcdeco-plugin' ),
		        'menu_name'         => esc_html__( 'Portfolio Category', 'arcdeco-plugin' ),
			)
		)
	);
}
add_action( 'init', 'arcdeco_register_portfolio_categories' );
