<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Arcdeco CF7 Widget.
 *
 * @since 1.0
 */

class Arcdeco_CF7_Form_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-cf7-form';
	}

	public function get_title() {
		return esc_html__( 'Contact Form 7', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return 'fas fa-headset';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'contact_form',
			[
				'label' => esc_html__( 'Select CF7 Form', 'arcdeco-plugin' ),
				'type' => Controls_Manager::SELECT,
				'default' => 1,
				'options' => $this->contact_form_list(),
			]
		); 

		$this->end_controls_section();

	}

	/**
	 * Render Contact Form List.
	 *
	 * @since 1.0
	 */
	protected function contact_form_list() {
		$cf7_posts = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

		$cf7_forms = array();
		
		if ( $cf7_posts ) {
			foreach ( $cf7_posts as $cf7_form ) {
				$cf7_forms[ $cf7_form->ID ] = $cf7_form->post_title;
			}
		} else {
			$cf7_forms[ esc_html__( 'No contact forms found', 'arcdeco-plugin' ) ] = 0;
		}

		return $cf7_forms;
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() { 
		$settings = $this->get_settings_for_display(); 
		?>

		<div class="contact-form">
			<?php echo do_shortcode( '[contact-form-7 id="'. esc_attr( $settings['contact_form'] ) .'"]' ); ?>
		</div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_CF7_Form_Widget() );