<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Arcdeco Team Widget.
 *
 * @since 1.0
 */

class Arcdeco_Team_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-team';
	}

	public function get_title() {
		return esc_html__( 'Team', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return 'fas fa-users';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label'       => esc_html__( 'Name', 'arcdeco-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter name', 'arcdeco-plugin' ),
				'default' => esc_html__( 'Enter name', 'arcdeco-plugin' ),
			]
		);

		$repeater->add_control(
			'role', [
				'label'       => esc_html__( 'Role', 'arcdeco-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter role', 'arcdeco-plugin' ),
				'default' => esc_html__( 'Enter role', 'arcdeco-plugin' ),
			]
		);

		$repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'arcdeco-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'arcdeco-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'name_styling',
			[
				'label' => esc_html__( 'Title', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		

		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Color', 'arcdeco-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .content-grid-team .content-grid__name' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography',
				'label' => esc_html__( 'Typography:', 'arcdeco-plugin' ),
				'selector' => '{{WRAPPER}} .content-grid-team .content-grid__name',
			]
		);			

		$this->end_controls_section();

		$this->start_controls_section(
			'role_styling',
			[
				'label' => esc_html__( 'Role', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		

		$this->add_control(
			'role_color',
			[
				'label' => esc_html__( 'Color', 'arcdeco-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .content-grid-team .content-grid__role' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'role_typography',
				'label' => esc_html__( 'Typography:', 'arcdeco-plugin' ),
				'selector' => '{{WRAPPER}} .content-grid-team .content-grid__role',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() { 
		$settings = $this->get_settings_for_display();

		?>
		
		<?php if ( $settings['items'] ) : ?>
		<!-- Team -->
		<div class="content-grid content-grid-team project-masonry">
		    <div class="gutter-sizer"></div>
		    <?php 
		        foreach ( $settings['items'] as $index => $item ) : 
		        $item_name = $this->get_repeater_setting_key( 'name', 'items', $index );
		    	$this->add_inline_editing_attributes( $item_name, 'basic' );

		    	$item_role = $this->get_repeater_setting_key( 'role', 'items', $index );
		    	$this->add_inline_editing_attributes( $item_role, 'basic' );
		    ?>
		    <!-- Person -->
	        <div class="content-grid__item js-scroll-show">
			    <div class="content-grid__link">
			        <?php if ( $item['image'] ) : $image = wp_get_attachment_image_url( $item['image']['id'], 'arcdeco_900xAuto' ); ?>
			        <picture class="content-grid__image-wrap image-wrap-fit js-zooming">
		                <img class="content-grid__image cover" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $item['name'] ); ?>" />
			        </picture>
			        <?php endif; ?>
			        <div class="content-grid__caption">
				        <?php if ( $item['name'] ) : ?>
				        <h2 class="content-grid__name title--h5">
				        	<span <?php echo $this->get_render_attribute_string( $item_name ); ?>>
				    			<?php echo wp_kses_post( $item['name'] ); ?>
				    		</span>
				        </h2>
				        <?php endif; ?>
				        <?php if ( $item['role'] ) : ?>
				        <p class="content-grid__role">
				        	<span <?php echo $this->get_render_attribute_string( $item_role ); ?>>
				    			<?php echo wp_kses_post( $item['role'] ); ?>
				    		</span>
				        </p>
				        <?php endif; ?>
			        </div>
				</div>
		    </div>
            <!-- /Person -->
            <?php endforeach; ?>
	    </div>
		<?php endif; ?>

		<?php 
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template() { ?>

		<# if ( settings.items ) { #>
		<!-- Team -->
		<div class="content-grid content-grid-team project-masonry">
		    <div class="gutter-sizer"></div>
		    <# _.each( settings.items, function( item, index ) {
		        var item_name = view.getRepeaterSettingKey( 'name', 'items', index );
				view.addInlineEditingAttributes( item_name, 'basic' );

				var item_role = view.getRepeaterSettingKey( 'role', 'items', index );
				view.addInlineEditingAttributes( item_role, 'basic' );
			#>
		    <!-- Person -->
	        <div class="content-grid__item js-scroll-show">
			    <div class="content-grid__link">
			        <# if ( item.image ) { #>
			        <picture class="content-grid__image-wrap image-wrap-fit js-zooming">
		                <img class="content-grid__image cover" src="{{{ item.image.url }}}" alt="{{{ item.name }}}" />
			        </picture>
			        <# } #>
			        <div class="content-grid__caption">
				        <# if ( item.name ) { #>
				        <h2 class="content-grid__name title--h5">
				        	<span {{{ view.getRenderAttributeString( item_name ) }}}>{{{ item.name }}}</span>
				        </h2>
				        <# } #>
				        <# if ( item.role ) { #>
				        <p class="content-grid__role">
				        	<span {{{ view.getRenderAttributeString( item_role ) }}}>{{{ item.role }}}</span>
				        </p>
				        <# } #>
			        </div>
				</div>
		    </div>
            <!-- /Person -->
            <# }); #>
	    </div>
		<# } #>

	<?php }
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_Team_Widget() );