<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Arcdeco About Video Widget.
 *
 * @since 1.0
 */
class Arcdeco_About_Video_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-about-video';
	}

	public function get_title() {
		return esc_html__( 'Video Section', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return 'fas fa-video';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Video', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'video_id',
			[
				'label' => esc_html__( 'Video ID (Youtube)', 'arcdeco-plugin' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Gu6z6kIukgg', 'arcdeco-plugin' ),
			]
		);

		$this->add_control(
			'video_image',
			[
				'label'       => esc_html__( 'Video Preview (Image)', 'arcdeco-plugin' ),
				'type'        => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'video_button',
			[
				'label' => esc_html__( 'Video Button (Text)', 'arcdeco-plugin' ),
				'type' => Controls_Manager::TEXT,
				'default'   => esc_html__( 'PLAY', 'arcdeco-plugin' ),
				'placeholder' => esc_html__( 'PLAY', 'arcdeco-plugin' ),
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() { 
		$settings = $this->get_settings_for_display(); ?>

		<div class="video-container js-video">
			<?php if ( $settings['video_id'] ) : ?>
            <iframe class="js-video-iframe" data-src="https://www.youtube.com/embed/<?php echo esc_attr( $settings['video_id'] ); ?>?showinfo=0&rel=0&autoplay=1"></iframe>
            <?php endif; ?>
		    <div class="video__poster js-image"<?php if ( $settings['video_image'] ) : $image = wp_get_attachment_image_url( $settings['video_image']['id'], 'arcdeco_1920xAuto' ); ?> data-image="<?php echo esc_attr( $image ); ?>"<?php endif; ?>>
		    	<?php if ( $settings['video_button'] ) : ?>
			    <button class="video__btn" type="button"><?php echo esc_html( $settings['video_button'] ); ?></button>
			    <?php endif; ?>
            </div>
	    </div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template() {
		?>

		<div class="video-container js-video">
			<# if ( settings.video_id ) { #>
            <iframe class="js-video-iframe" data-src="https://www.youtube.com/embed/{{{ settings.video_id }}}?showinfo=0&rel=0&autoplay=1"></iframe>
            <# } #>
		    <div class="video__poster js-image"<# if ( settings.video_image ) { #> data-image="{{{ settings.video_image.url }}}"<# } #>>
		    	<# if ( settings.video_button ) { #>
			    <button class="video__btn" type="button">{{{ settings.video_button }}}</button>
			    <# } #>
            </div>
	    </div>

		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_About_Video_Widget() );