( function( $ ) {
	"use strict"; 
	
	var count = 2;
	var total = ajax_portfolio_infinite_scroll_data.max_num;

	//console.log('totalNumber: ' + total);
	var flag = 1;

	$(window).on('scroll', function(){
	    if ( $(window).scrollTop() + $(window).height() >= $('.footer').offset().top ) {
	        if ( count > total ) {
	            return false;
	        } else {
	        	if( flag == 1 ){
	        		//console.log('pageNumber: ' + count);
	            	loadContent(count);
	            }
	        }
	        if( flag == 1 ){
	        	flag = 0;
	        	count++;
	        }
	    }
	});

	function loadContent(pageNumber) {
	    $.ajax({
	        url: ajax_portfolio_infinite_scroll_data.url,
	        type:'POST',
	        data: "action=infinite_scroll&page_no="+ pageNumber + '&post_type=portfolio' + '&page_id=' + ajax_portfolio_infinite_scroll_data.page_id,
	        success: function(html){
	        	html = html.replace(/js-scroll-show/g, '');
	        	html = html.replace(/js-scroll-show-infinite/g, '');

	            var $html = $(html);
	            var $container = $('.project-masonry');

	            $html.imagesLoaded(function(){
					$container.append($html);
					$container.isotope('appended', $html );
				});
	            
	            flag = 1;
	        }
	    });
	    return false;
	}
} )( jQuery );