<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package arcdeco
 */

if ( ! function_exists( 'arcdeco_get_categories' ) ) {
	/**
	 * Displays Categories
	 */
	function arcdeco_get_categories( $taxonomy, $order_by = 'DESC' ) {
		$args = array(
			'type'			=> 'post',
			'child_of'		=> 0,
			'parent'		=> '',
			'orderby'		=> 'name',
			'order'			=> $order_by,
			'hide_empty'	=> 1,
			'hierarchical'	=> 1,
			'taxonomy'		=> $taxonomy,
			'pad_counts'	=> false 
		);

		return get_categories( $args );
	}
}

if ( ! function_exists( 'arcdeco_post_details' ) ) :
	/**
	 * Displays post details: date, author, categories.
	 */
	function arcdeco_post_details() {
		if ( is_singular() ) :
			$categories_list = get_the_category_list( esc_html__( ', ', 'arcdeco' ) );

			echo esc_html( get_the_date() ) . esc_html( ' / by ', 'arcdeco' ) . '<a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a>';

			if ( $categories_list ) :
				printf( esc_html__( ' in %1$s', 'arcdeco' ), $categories_list );
			endif;
		endif; // End is_singular().
	}
endif;

if ( ! function_exists( 'arcdeco_post_navigantion' ) ) :
	/**
	 * Displays an optional prev/next nagigations.
	 */
	function arcdeco_post_navigantion() {
		if ( is_singular() ) :
			
			$prev_post = get_adjacent_post( false, '', false );
			$next_post = get_adjacent_post( false, '', true );
			$archive_url = 0;
			$archive_page_id = get_field( get_post_type() . '_page', 'option' );
			if ( ! $archive_page_id ) {
				$archive_url = get_post_type_archive_link( get_post_type() );
			} else {
				$archive_url = get_permalink( $archive_page_id );
			}
			
			?>

			<div class="post-footer__nav">
				<?php if ( is_a( $prev_post, 'WP_Post' ) ) : ?>
				<a href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>" class="btn-link"><?php echo esc_html__( 'Prev', 'arcdeco' ); ?></a>
				<?php endif; ?>
				<?php if ( is_a( $next_post, 'WP_Post' ) ) : ?>
				<a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>" class="btn-link btn-link--rearward"><?php echo esc_html__( 'Next', 'arcdeco' ); ?></a>
				<?php endif; ?>
			</div>

		<?php
		endif; // End is_singular().
	}
endif;

if ( ! function_exists( 'arcdeco_entry_footer' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function arcdeco_entry_footer() {
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html_x( '', 'list item separator', 'arcdeco' ) );
			if ( $tags_list ) {
				/* translators: 1: list of tags. */
				echo '<span class="tags-links">' . '<span>' . esc_html__( 'Tags:', 'arcdeco' ) . '</span>' . $tags_list . '</span>';
			}
		}

		edit_post_link(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Edit <span class="screen-reader-text">%s</span>', 'arcdeco' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			),
			'<span class="edit-link">',
			'</span>'
		);
	}
endif;

if ( ! function_exists( 'arcdeco_comment' ) ) {
	/**
	 * Displays post comments.
	 */
	function arcdeco_comment( $comment, $args, $depth ) {
		?>
			<!-- Item Comment -->
			<li <?php comment_class( 'comment-item' ); ?> id="li-comment-<?php comment_ID(); ?>">
				<div id="comment-<?php comment_ID(); ?>" class="comment comment-box">
					<?php
						$avatar_size = 64;
						if ( '0' != $comment->comment_parent ){
							$avatar_size = 64;
						}
						echo get_avatar( $comment, $avatar_size );
					?>
					<div class="comment-box__body">
						<div class="content-caption post-content description">
							<h5 class="comment-box__details"><?php comment_author_link(); ?> <span>/ <?php comment_date(); ?></span></h5>
							<?php comment_text(); ?>
						</div>
					</div>
					<div class="comment-footer">
						<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
					</div>
				</div>
		<?php
	}
}