<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package arcdeco
 */

get_header();
?>
	
	<?php while ( have_posts() ) : the_post(); ?>

	<!-- Page -->
	<section class="section blog__single">
		<header class="header-post header-page">
		    <div class="container text-center">
			    <div class="row justify-content-center">
				    <div class="col-12 js-scroll-show">
		                <h1 class="title title--h1 title--separation-center"><?php the_title(); ?></h1>
					</div>
			    </div>
			</div>
		</header>
		
		<div class="container">

			<!-- Content -->
			<?php get_template_part( 'template-parts/content', 'page' ); ?>
			
			<!-- Footer post -->
			<footer class="post-footer">

				<!-- Post nav -->
				<?php 
				
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'arcdeco' ),
					'after'  => '</div>',
				) );

				?>

			</footer>
			
			<?php if ( comments_open() || get_comments_number() ) : ?>
			<!-- Comments -->
			<div class="row justify-content-center">
				<div class="col-12 col-lg-10 col-xl-9">
					<?php
						// If comments are open or we have at least one comment, load up the comment template.
						comments_template();
					?>
				</div>	
			</div>
			<?php endif; ?>
		</div>

	</section>
	<!-- /Page -->

	<?php endwhile; ?>

<?php
get_footer();
