<?php
/**
 * Template Name: Blog
 *
 * @package arcdeco
*/

get_header();
?>
	
	<?php

	$title = get_field( 'title' );
	$subtitle = get_field( 'subtitle' );

	/*get options*/
	$layout = get_field( 'blog_layout', 'option' );

	$posts_per_page = get_option( 'posts_per_page' );
	$paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;

	$posts = wp_count_posts( 'post' );
	$total_posts = $posts->publish;

	$args = array(
		'post_type' => 'post',
		'posts_per_page' => $posts_per_page,
		'paged' => $paged,
		'post_status' => 'publish',
		'order' => 'desc'
	);
	$q = new WP_Query($args);

	?>

	<div class="container">
		<header class="header-page header-page-posts">
			<h1 class="title title--h1 js-lines"><?php echo esc_html( $title ); ?></h1>
			<?php if ( $subtitle ) : ?>
			<p class="description js-scroll-show"><?php echo esc_html( $subtitle ); ?></p>
			<?php endif; ?>
		</header>
		
		<?php if ( $layout == 0 ) : ?>
		<div class="news__wrap__fullwidth _sedibar">
			<div class="row">
				<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
				<div class="col-md-9">
				<?php else : ?>
				<div class="col-md-12">
				<?php endif; ?>
				<div class="articles-container">
		<?php endif; ?>
		<?php if ( $layout == 1 ) : ?>
		<div class="articles-container">
		<?php endif; ?>
		<?php if ( $layout == 2 ) : ?>
		<div class="articles-container">
		<div class="content-grid news-masonry filter-container">
				<div class="gutter-sizer-two"></div>
		<?php endif; ?>

		<?php if ( $q->have_posts() ) :
			while ( $q->have_posts() ) : $q->the_post();
				if ( $layout == 1 ) :
					get_template_part( 'template-parts/content-horizontal' );
				elseif ( $layout == 2 ) :
					get_template_part( 'template-parts/content-grid' );
				else :
					get_template_part( 'template-parts/content' );
				endif;
			endwhile; wp_reset_postdata();
		?>

		<?php if ( $layout == 2 ) : ?></div><?php endif; ?>
		</div>

		<div class="pager">
			<?php
				$big = 999999999; // need an unlikely integer

				echo paginate_links( array(
					'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
					'format' => '?paged=%#%',
					'current' => max( 1, get_query_var('paged') ),
					'total' => $q->max_num_pages,
					'prev_text' => esc_html__( 'Prev', 'arcdeco' ),
					'next_text' => esc_html__( 'Next', 'arcdeco' ),
				) );
			?>
		</div>
		<?php else :
			get_template_part( 'template-parts/content', 'none' );
		endif; ?>

		<?php if ( $layout == 0 ) : ?>
		</div>
			<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
			<div class="col-md-3">
				<div class="col__sedebar">
					<?php get_sidebar(); ?>
				</div>
			</div>
			<?php endif; ?>
		</div>
		</div>
		<?php endif; ?>
	</div>

<?php
get_footer();