<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package arcdeco
 */

?>

<?php

$img_size = get_query_var('img_size');

//options
$blog_excerpt = get_field( 'blog_excerpt', 'option' );

//content
if( $img_size == '800' ) :
    $image = get_the_post_thumbnail_url( get_the_ID(), 'arcdeco_800x800' );
else :
    $image = get_the_post_thumbnail_url( get_the_ID(), 'arcdeco_900xAuto' );
endif;

?>

<!-- Post -->
<article id="post-<?php the_ID(); ?>" <?php post_class('content-grid__item-two onHover js-scroll-show'); ?>>
    <a class="content-grid__link" href="<?php echo esc_url( get_permalink() ); ?>">
        <?php if ( $image ) : ?>
        <picture class="content-grid__image-wrap js-zooming">
            <a href="<?php echo esc_url( get_permalink() ); ?>">
                <img class="cover lazyload" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>" />
            </a>
        </picture>
        <?php endif; ?>
        <div class="content-grid__caption">
            <div class="post-details">
                <?php echo esc_html( 'By', 'arcdeco' ); ?> <strong><?php echo esc_html( get_the_author() ); ?></strong> <?php echo esc_html( ' / ', 'arcdeco' ); ?> <?php echo esc_html( get_the_date() ); ?>
            </div>
            <h2 class="title title--h5 title--tone"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h2>
            <?php if ( ! $blog_excerpt ) : ?>
            <div class="content-grid__description"><?php the_excerpt(); ?></div>
            <?php endif; ?>
        </div>
    </a>
</article>
<!-- /Post --><!-- #post-<?php the_ID(); ?> -->