<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package arcdeco
 */

?>

<?php

//options
$blog_excerpt = get_field( 'blog_excerpt', 'option' );

//content
$image = get_the_post_thumbnail_url( get_the_ID(), 'arcdeco_1170x658' );

?>

<!-- Post -->
<article id="post-<?php the_ID(); ?>" <?php post_class('item-post-horizon js-scroll-show'); ?>>
    <?php if ( $image ) : ?>
    <picture class="item-post-horizon__image-wrap">
        <a href="<?php echo esc_url( get_permalink() ); ?>">
        	<img class="cover lazyload" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>" />
        </a>
    </picture>
    <?php endif; ?>
    <div class="item-post-horizon__caption">
        <div class="post-details"><?php echo esc_html( 'By', 'arcdeco' ); ?> <strong><?php echo esc_html( get_the_author() ); ?></strong> <?php echo esc_html( ' / ', 'arcdeco' ); ?> <?php echo esc_html( get_the_date() ); ?></div>
        <h2 class="title title--h4 title--separation"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h2>
        <?php if ( ! $blog_excerpt ) : ?>
        <div class="item-post-horizon__description"><?php the_excerpt(); ?></div>
        <?php endif; ?>
    </div>
</article>
<!-- /Post --><!-- #post-<?php the_ID(); ?> -->