<?php

/*
Arcdeco Shop */

?>

<?php get_header(); ?>

<?php

$sidebar_shop = get_field( 'wooshop_sidebar', 'option' );

if ( ! $sidebar_shop ) {
	$sidebar_shop = 'hide';
}

$parallax_shop = get_field( 'wooshop_parallax', 'option' );

?>

<?php if ( true == $parallax_shop ) : ?>

<?php
	$parallax_shop_img = get_field( 'wooshop_parallax_img', 'option' );
	$parallax_shop_title = woocommerce_page_title( false );
	if ( $parallax_shop_title == '' ) {
		$parallax_shop_title = get_field( 'wooshop_parallax_title', 'option' );
	}
	$parallax_shop_social = get_field( 'wooshop_parallax_social', 'option' );
	$social_links = get_field( 'social_links', 'option' );
?>

<header class="hero hero-shop overlay--45">
    <div class="hero__header align-items-center">
    	<?php if ( $parallax_shop_title ) : ?>
	    <h1 class="title title--display-1 text-center js-words">
	    	<?php echo wp_kses_post( $parallax_shop_title ); ?>
	    </h1>
	    <?php endif; ?>
	</div>
	
	<?php if ( $parallax_shop_social == 'yes' && $social_links ) : ?>
	<!-- Social -->
	<div class="social social-floating">
		<?php foreach ( $social_links as $social_link ) : ?>
        <a class="social__link" href="<?php echo esc_url( $social_link['url'] ); ?>" target="_blank"><i class="<?php echo esc_attr( $social_link['icon'] ); ?>"></i></a>
    	<?php endforeach; ?>
    </div>
    <?php endif; ?>

	<?php if ( $parallax_shop_img ) : $image = wp_get_attachment_image_url( $parallax_shop_img, 'arcdeco_1920xAuto' ); ?>
    <div class="hero__image cover js-scale js-parallax" style="background-image: url(<?php echo esc_url( $image ); ?>);"></div>
    <?php endif; ?>
</header>

<?php endif; ?>

<div class="container shop-page<?php if ( ! $parallax_shop ) : ?> header-page<?php endif; ?>" id="card-shop-page">
  	<div class="row">
  	<?php if ( 'left' == $sidebar_shop && ! is_product() ) : ?>
		<div class="col-md-3 col-padding-right">

		<?php if ( is_active_sidebar( 'shop-sidebar' ) ) : ?>

			 <div id="sidebar" class="widget-area content-sidebar" role="complementary">

	         <?php dynamic_sidebar( 'shop-sidebar' ); ?>

	         </div>

	     <?php endif; ?>

		</div>

		<div class="col-md-9">
			
			<?php woocommerce_breadcrumb(); ?>
			<?php woocommerce_content(); ?>

		</div>
	<?php elseif ( 'right' == $sidebar_shop && ! is_product() ) : ?>
		<div class="col-md-9">
			
			<?php woocommerce_breadcrumb(); ?>
			<?php woocommerce_content(); ?>

		</div>

		<div class="col-md-3 col-padding-left">

		<?php if ( is_active_sidebar( 'shop-sidebar' ) ) : ?>

			 <div id="sidebar" class="widget-area content-sidebar" role="complementary">

	         <?php dynamic_sidebar( 'shop-sidebar' ); ?>

	         </div>

	     <?php endif; ?>

		</div>
	<?php else : ?>

		<div class="col-md-12">
			
			<?php woocommerce_breadcrumb(); ?>
			<?php woocommerce_content(); ?>

		</div>

	<?php endif; ?>
	
	</div>
</div>

<?php get_footer(); ?>