<?php
/**
 * Plugin Name: Arcdeco Plugin
 * Plugin URI: https://arcdeco.bslthemes.com
 * Description: This plugin it's designed for Arcdeco Theme
 * Version: 1.0.8
 * Author: beshleyua
 * Author URI: https://arcdeco.bslthemes.com
 * Text Domain: arcdeco-plugin
 * Domain Path: /language/
 * License: http://www.gnu.org/licenses/gpl.html
 */

/* Load plugin text-domain */
function arcdeco_plugin_load_textdomain() {
	load_plugin_textdomain( 'arcdeco-plugin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'arcdeco_plugin_load_textdomain' );

/* Custom Post Types */
require plugin_dir_path( __FILE__ ) . 'custom-post-types.php';

/* ACF arcdeco fields extention */
require plugin_dir_path( __FILE__ ) . 'acf-ext/acf-ui-google-font/acf-ui-google-font.php';

/**
 * Include Elementor Functions
 */
require_once plugin_dir_path( __FILE__ ) . 'elementor/functions.php';

/**
 * Enabled Custom Post Type Elementor Supports
 */
function arcdeco_elementor_cpt_support() {
    $cpt_support = get_option( 'elementor_cpt_support' );

	if( ! $cpt_support ) {
	    $cpt_support = [ 'page', 'post', 'portfolio' ];
	    update_option( 'elementor_cpt_support', $cpt_support );
	} else if( ! in_array( 'portfolio', $cpt_support ) ) {
	    $cpt_support[] = 'portfolio';
	    update_option( 'elementor_cpt_support', $cpt_support );
	}
}
function arcdeco_elementor_disable_fonts_and_colors() {
	$color_schemes = get_option( 'elementor_disable_color_schemes' );
	$typography_schemes = get_option( 'elementor_disable_typography_schemes' );

	if( ! $color_schemes ) {
	    update_option( 'elementor_disable_color_schemes', 'yes' );
	}
	if( ! $typography_schemes ) {
	    update_option( 'elementor_disable_typography_schemes', 'yes' );
	}	
}

/* Update permalink structure when plugin is activated */
function arcdeco_plugin_activate() {
	update_option( 'rewrite_rules', '' );
	arcdeco_elementor_cpt_support();
	arcdeco_elementor_disable_fonts_and_colors();
}
function arcdeco_plugin_deactivate() {
	update_option( 'rewrite_rules', '' );
}

register_activation_hook( __FILE__, 'arcdeco_plugin_activate' );
register_deactivation_hook( __FILE__, 'arcdeco_plugin_deactivate' );

?>