(function ($) {
	"use strict";

	function updateSwiperSlider() {
        $('.slider').each(function() {
            var interleaveOffset = 0.7;

            var sliderCaption = new Swiper('.slider__caption', {
                slidesPerView: 1,
				loop: true,
				parallax: true,
                effect: 'fade',
				fadeEffect: {
                    crossFade: true
                },
                speed: 1200,
                simulateTouch: false,
				pagination: {
                    el: '.slider-pagination-fraction',
                    type: 'custom',
					progressbarOpposite: true,
		            clickable: false,
					renderCustom: function(swiper, current, total) {
                        var i = current ? current : 0;
                        return '<div>' + ('0' + i) + '</div><div>' + ('0' + total) + '</div>';
                    }
                }
            });
			
            var sliderImage = new Swiper('.slider__image', {
                slidesPerView: 1,
                loop: true,
				parallax: true,
			    speed: 1200,
                simulateTouch: false,
	            roundLengths: true,
				watchSlidesProgress: true,
                pagination: {
                    el: '.slider-pagination-progressbar',
                    type: 'progressbar',
					progressbarOpposite: true,
		            clickable: false
                },
                autoplay: false,
                keyboard: {
	                enabled: true
	            },
                mousewheel: false,
                navigation: {
                    nextEl: '.slider-next',
                    prevEl: '.slider-prev'
                },
				breakpoints: {
					768: {
                        pagination: {
                            progressbarOpposite: false,
						}
                    }
				}, 
				on: {
                    progress: function() {
						if (!/Edge/.test(navigator.userAgent)) {
                            var swiper = this;
                            for (var i = 0; i < swiper.slides.length; i++) {
                                var slideProgress = swiper.slides[i].progress,
                                    innerOffset = swiper.width * interleaveOffset,
                                    innerTranslate = slideProgress * innerOffset;					
                                swiper.slides[i].querySelector('.cover-slider').style.transform = 'translateX(' + innerTranslate + 'px)';								
                            }
						}
                    },
                    touchStart: function() {
                        var swiper = this;
                        for (var i = 0; i < swiper.slides.length; i++) {
                            swiper.slides[i].style.transition = "";
                        }
                    },
                    setTransition: function(speed) {
						if (!/Edge/.test(navigator.userAgent)) {
                            var swiper = this;
                            for (var i = 0; i < swiper.slides.length; i++) {
                                swiper.slides[i].style.transition = speed + "ms";
                                swiper.slides[i].querySelector(".cover-slider").style.transition = speed + "ms";
                            }
						}
                    }
                }
            });
					
            sliderCaption.controller.control = sliderImage;
            sliderImage.controller.control = sliderCaption;
		});

		/* Portfolio carousel */
		$('.carousel').each(function() {
			var carouselProject = new Swiper('.carousel-container', {
				slidesPerView: 4,
				parallax: true,
				speed: 1000,
				simulateTouch: false,
				keyboard: {
					enabled: true
				},
				mousewheel: false,
				navigation: {
					nextEl: '.slider-next',
					prevEl: '.slider-prev'
				},
				breakpoints: {
					1600: {
						slidesPerView: 3
					},
					1024: {
						slidesPerView: 2
					},
					768: {
						slidesPerView: 1,
						simulateTouch: true
					}
				}
			});
		});

		/* Project slider */
		$('.project-slider').each(function() {
			var carouselProject = new Swiper('.project-slider', {
				slidesPerView: 'auto',
				centeredSlides: true,
				loop: true,
				grabCursor: true,
				mousewheelControl: false,
				keyboard: {
					enabled: true,
				},
				//parallax: true,
				speed: 1000,
				watchSlidesProgress: true,
				pagination: {
					el: '.slider-pagination-progressbar',
					type: 'progressbar',
					clickable: false
				},
				navigation: {
					nextEl: '.swiper-button-next',
					prevEl: '.swiper-button-prev',
				}
			});
		});
	};

	/* Init Elementor Front Scripts */
	$(window).on('elementor/frontend/init', function () {

		// Widgets
		elementorFrontend.hooks.addAction( 'frontend/element_ready/arcdeco-service.default', function() {
			var editorActive = $('body').hasClass('elementor-editor-active');
			if ( editorActive ) {
		    	$('.js-image').each(function(){
		        	var dataImage = $(this).attr('data-image');
		        	$(this).css('background-image', 'url(' + dataImage + ')');
		    	});
		    }
		} );
		elementorFrontend.hooks.addAction( 'frontend/element_ready/arcdeco-hero-slider.default', function() {
			var editorActive = $('body').hasClass('elementor-editor-active');
			if ( editorActive ) {
				//update sliders
				updateSwiperSlider();

				//update image background
				$('.js-image').each(function(){
			        var dataImage = $(this).attr('data-image');
			        $(this).css('background-image', 'url(' + dataImage + ')');
			    });
			}
		} );
		elementorFrontend.hooks.addAction( 'frontend/element_ready/arcdeco-about-video.default', function() {
			var editorActive = $('body').hasClass('elementor-editor-active');
		    if( editorActive ) {
		    	//update image background
		    	$('.js-image').each(function(){
		        	var dataImage = $(this).attr('data-image');
		        	$(this).css('background-image', 'url(' + dataImage + ')');
		    	});
		    }
		} );

		// Global
		elementorFrontend.hooks.addAction( 'frontend/element_ready/global', function( $scope ) {
			
		} );
		elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', function( $scope ) {
			var editorActive = $('body').hasClass('elementor-editor-active');
			if( editorActive ) {
				//update
			}
		} );
	});
})(jQuery);