<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Arcdeco Gallery Image Widget.
 *
 * @since 1.0
 */
class Arcdeco_Button_Link_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-button-link';
	}

	public function get_title() {
		return esc_html__( 'Button (Link)', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return ' fas fa-link';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Button (Link)', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'URL', 'arcdeco-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'text',
			[
				'label' => esc_html__( 'Text', 'arcdeco-plugin' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter Button Text', 'arcdeco-plugin' ),
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() { 
		$settings = $this->get_settings_for_display(); 

		$this->add_inline_editing_attributes( 'text', 'none' );

		?>

        <!-- Button Link -->
		<a<?php if ( $settings['link'] ) : if ( $settings['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['link']['url'] ); ?>"<?php endif; ?> class="btn-link js-scroll-show">
			<span <?php echo $this->get_render_attribute_string( 'text' ); ?>>
				<?php echo esc_html( $settings['text'] ); ?>
			</span>
		</a>
		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template() {
		?>
		
		<#
		view.addInlineEditingAttributes( 'text', 'none' );
		#>

        <!-- Button Link -->
		<a<# if ( settings.link ) { #><# if ( settings.link.is_external ) { #> target="_blank"<# } #><# if ( settings.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.link.url }}}"<# } #> class="btn-link js-scroll-show">
			<span {{{ view.getRenderAttributeString( 'text' ) }}}>{{{ settings.text }}}</span>
		</a>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_Button_Link_Widget() );