<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Arcdeco About Heading Widget.
 *
 * @since 1.0
 */
class Arcdeco_Project_Gallery_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-project-gallery';
	}

	public function get_title() {
		return esc_html__( 'Project Gallery', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return 'fas fa-images';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'gallery',
			[
				'label' => esc_html__( 'Images', 'arcdeco-plugin' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
			]
		);

		$this->add_control(
			'cols',
			[
				'label' => esc_html__( 'Columns', 'arcdeco-plugin' ),
				'type' => Controls_Manager::SELECT,
				'default' => 1,
				'options' => [
					1 => esc_html__( 'One', 'arcdeco-plugin' ),
					2 => esc_html__( 'Two', 'arcdeco-plugin' ),
				],
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

		<div class="container">
			<!-- Gallery -->
			<div class="row justify-content-center">
			    <div class="col-12">
			    	<?php if ( $settings['gallery'] ) : ?>
				    <div class="gallery<?php if ( $settings['cols'] == 2 ) : ?> gallery-two<?php endif; ?>">
				    	<?php foreach ( $settings['gallery'] as $image ) : ?>
					    <div class="gallery__item reveal-box">
				            <img class="cover zoom-cursor lazyload" src="<?php echo esc_url( $image['url'] ); ?>" data-zoomable alt="<?php echo esc_attr__( 'Image', 'arcdeco-plugin' ); ?>" />
						    <span class="reveal-overlay"></span>
					    </div>
						<?php endforeach; ?>
				    </div>
				    <?php endif; ?>
				</div>
			</div>
		</div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template() { ?>

		<div class="container">
			<!-- Gallery -->
			<div class="row justify-content-center">
			    <div class="col-12">
			    	<# if ( settings.gallery ) { #>
				    <div class="gallery<# if ( settings.cols == 2 ) { #> gallery-two<# } #>">
				    	<# _.each( settings.gallery, function( image ) { #>
					    <div class="gallery__item reveal-box">
				            <img class="cover zoom-cursor lazyload" src="{{{ image.url }}}" data-zoomable alt="" />
						    <span class="reveal-overlay"></span>
					    </div>
						<# }); #>
				    </div>
				    <# } #>
				</div>
			</div>
		</div>

	<?php }
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_Project_Gallery_Widget() );