<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Arcdeco Service Widget.
 *
 * @since 1.0
 */

class Arcdeco_Service_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-service';
	}

	public function get_title() {
		return esc_html__( 'Service', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return 'fas fa-concierge-bell';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'arcdeco-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter your title', 'arcdeco-plugin' ),
				'default'     => esc_html__( 'Architecture and decor.', 'arcdeco-plugin' ),
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'arcdeco-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter your Description', 'arcdeco-plugin' ),
				'default'     => esc_html__( 'The essence of interior design will always be about people and how they live.', 'arcdeco-plugin' ),
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label'       => esc_html__( 'Background Image', 'arcdeco-plugin' ),
				'type'        => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'arcdeco-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label' => esc_html__( 'Title', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'arcdeco-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .services__item-details .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography:', 'arcdeco-plugin' ),
				'selector' => '{{WRAPPER}} .services__item-details .title',
			]
		);			

		$this->end_controls_section();

		$this->start_controls_section(
			'description_styling',
			[
				'label' => esc_html__( 'Description', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		

		$this->add_control(
			'description_color',
			[
				'label' => esc_html__( 'Color', 'arcdeco-plugin' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .services__item-details .description' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => esc_html__( 'Typography:', 'arcdeco-plugin' ),
				'selector' => '{{WRAPPER}} .services__item-details .description',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() { 
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'description', 'basic' );

		?>
		
		<!-- Item -->
	    <div class="services__item js-scroll-show overlay--45">
	    	<?php if ( $settings['link']['url'] ) : ?>
	    	<a <?php if ( $settings['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['link']['url'] ); ?>" class="zoom-cursor">
	    	<?php endif; ?>
	    	<?php if ( $settings['bg_image'] ) : ?>
		    <div class="services__item-bg js-image" data-image="<?php echo esc_url( $settings['bg_image']['url'] ); ?>"></div>
		    <?php endif; ?>
            <div class="services__item-details">
            	<?php if ( $settings['title'] ) : ?>
			    <h4 class="title title--h3 js-lines">
			    	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>><?php echo wp_kses_post( $settings['title'] ); ?></span>
			    </h4>
				<?php endif; ?>
				<?php if ( $settings['description'] ) : ?>
				<p class="description js-lines">
					<span <?php echo $this->get_render_attribute_string( 'description' ); ?>><?php echo wp_kses_post( $settings['description'] ); ?></span>
				</p>
				<?php endif; ?>
			</div>
			<?php if ( $settings['link']['url'] ) : ?>
			</a>
			<?php endif; ?>
		</div>
		
		<?php 
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template() { ?>
		
		<#
		view.addInlineEditingAttributes( 'title', 'basic' );
		view.addInlineEditingAttributes( 'description', 'basic' );
		#>

		<!-- Item -->
	    <div class="services__item js-scroll-show overlay--45">
			<# if ( settings.link.url ) { #>
	    	<a<# if ( settings.link.is_external ) { #> target="_blank"<# } #><# if ( settings.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.link.url }}}" class="zoom-cursor">
	    	<# } #>
		    <# if( settings.bg_image ) { #>
		    <div class="services__item-bg js-image" data-image="{{{ settings.bg_image.url }}}"></div>
		    <# } #>
            <div class="services__item-details">
			    <# if( settings.title ) { #>
			    <h4 class="title title--h3 js-lines">
			    	<span {{{ view.getRenderAttributeString( 'title' ) }}}>{{{ settings.title }}}</span>
			    </h4>
			    <# } #>
			    <# if( settings.description ) { #>
				<p class="description js-lines">
					<span {{{ view.getRenderAttributeString( 'description' ) }}}>{{{ settings.description }}}</span>
				</p>
				<# } #>
			</div>
			<# if ( settings.link ) { #>
			</a>
			<# } #>
		</div>

	<?php }
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_Service_Widget() );