<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package arcdeco
 */

?>

<?php

$hide_footer = get_field( 'hide_footer' );

if ( is_404() ) {
	$hide_footer = 1;
}

$footer_text = get_field( 'footer_text', 'options' );
$social_links = get_field( 'social_links', 'options' );
$cursor = get_field( 'cursor', 'options' );

?>
		<?php if ( ! $hide_footer ) : ?>
		<!-- Footer -->
	    <footer class="footer js-scroll-show">
	        <div class="container">
		        <div class="row">
			        <div class="col-12">
				        <?php if ( $footer_text ) : ?>
				        <div class="footer__contacts list-unstyled">
					        <?php echo wp_kses_post( $footer_text ); ?>
				        </div>
				        <?php else : ?>
				        <div class="footer__contacts list-unstyled">
					        <?php echo esc_html__( '&copy; 2020. All rights reserved', 'arcdeco' ); ?>
				        </div>	
				        <?php endif; ?>
				        <?php if ( $social_links ) : ?>
			            <div class="social footer__social">
			            	<?php foreach ( $social_links as $link ) : ?>
		                    <a class="social__link" href="<?php echo esc_url( $link['url'] ); ?>" target="_blank"><i class="<?php echo esc_attr( $link['icon'] ); ?>"></i></a>
		                	<?php endforeach; ?>
		                </div>
		                <?php endif; ?>
				    </div>
			    </div>
		    </div>
	    </footer>
	    <!-- /Footer -->
		<?php endif; ?>
	</main>

	<!-- Cursor -->
	<div class="node" id="node"></div>
	<div class="cursor<?php if ( $cursor ) : ?> cursor--disabled<?php endif;?>" id="cursor"></div>

	<div class="back-to-top zoom-cursor magnetic"></div>
	
	<?php wp_footer(); ?>

</body>
</html>