<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package arcdeco
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<!-- Meta Data -->
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<?php

$header_logo_img = get_field( 'header_logo_img', 'option' );
$nav_angle = get_field( 'nav_angle', 'option' );
$menu_type = get_field( 'menu_type', 'option' );
$theme_ui = get_field( 'theme_ui', 'option' );
$header_logo_magnetic = get_field( 'header_logo_magnetic', 'option' );
$header_menu_magnetic = get_field( 'header_menu_magnetic', 'option' );
$disable_preloader = get_field( 'disable_preloader', 'option' );
$preloader_logo = get_field( 'preloader_logo', 'option' );
if ( ! $preloader_logo ) {
	$preloader_logo = $header_logo_img;
}

$body_custom_classes = '';

if ( $menu_type == 1 ) :
	$body_custom_classes = 'body-horizontal-menu';
endif;

?>

<body <?php body_class( $body_custom_classes ); ?>>
	<?php wp_body_open(); ?>

	<!-- Preloader -->
	<div class="preloader">
		<?php if ( ! $disable_preloader ) : ?>
		<div class="preloader__wrap">
			<?php if ( $preloader_logo ) : ?>
			<img class="preloader__logo" src="<?php echo esc_url( $preloader_logo ); ?>" alt="<?php echo esc_attr( bloginfo('name') ); ?>">
			<?php endif; ?>
			<div class="preloader__progress"><span></span></div>
		</div>
		<?php endif; ?>
	</div>

	<?php if ( is_singular( array( 'post', 'portfolio' ) ) ) : ?>
	<!-- Scroll Indicator -->
	<div class="scroll-line"></div>
	<?php endif; ?>

	<!-- Top -->
	<nav class="header-navbar navbar<?php if ( $menu_type == 2 || $menu_type == 3 ) : ?> navbar-compact<?php endif; ?><?php if ( $theme_ui == 1 ) : ?> navbar-change navbar--white<?php endif; ?>">
		<?php if ( ! $nav_angle ) : ?>
		<div class="angle"><svg width="35" height="35" viewBox="0 0 35 35" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 0H35L0 35V0Z" fill="#FFB951"/></svg></div>
		<?php endif; ?>
		<div class="mr-auto">
			<a class="logo-link<?php if ( ! $header_logo_magnetic ) : ?> magnetic<?php endif; ?>" href="<?php echo esc_url( home_url() ); ?>" title="<?php echo esc_attr( bloginfo('name') ); ?>">
				<?php if ( $header_logo_img ) : ?>
				<img class="logotype" src="<?php echo esc_url( $header_logo_img ); ?>" alt="<?php echo esc_attr( bloginfo('name') ); ?>">
				<?php else : ?>
				<span class="logotype__title"><?php echo esc_html( bloginfo('name') ); ?></span>
				<span class="logotype__sub"><?php echo esc_html( bloginfo('description') ); ?></span>
				<?php endif; ?>
			</a>
		</div>
		
		<div class="ml-sm-auto">
			<button class="hamburger zoom-cursor<?php if ( ( $menu_type == 2 || $menu_type == 3 ) && ! $header_menu_magnetic ) : ?> magnetic<?php endif; ?><?php if ( $menu_type == 3 ) : ?> is-sideNav<?php endif; ?>" type="button">
				<span class="hamburger__inner"></span>
			</button>

			<?php 
			if ( $menu_type == 1 || ! $menu_type ) :
			
			wp_nav_menu( array(
				'theme_location' => 'primary',
				'container' => '',
				'menu_class' => 'nav',
				'walker' => new arcdeco_TopmenuHorizontal_Walker(),
			) );

			endif; ?>

			<!-- Woocommerce cart -->
			<?php if ( class_exists( 'WooCommerce' ) ) : ?>
				<div class="cart-btn<?php if ( WC()->cart->get_cart_contents_count() == 0 ) : ?> cart-btn-empty<?php endif; ?>">
					<div class="cart-icon zoom-cursor<?php if ( ! $header_menu_magnetic ) : ?> magnetic<?php endif; ?>">
						<span class="cart-count"><?php echo sprintf (_n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'arcdeco' ), WC()->cart->get_cart_contents_count() ); ?></span> 
					</div>
					<div class="cart-widget">
						<?php woocommerce_mini_cart(); ?>
					</div>
				</div>
			<?php endif; ?>

		</div>
	</nav>
	<!-- /Top -->

	<?php if ( $menu_type == 2 || $menu_type == 1 ) : ?>
	<!-- Overlay nav -->
	<div class="nav-overlay">
		<div class="nav-overlay__bg"></div>
		<div class="nav-overlay__container">
			<?php
			
			wp_nav_menu( array(
				'theme_location' => 'primary',
				'container' => '',
				'menu_class' => 'nav-overlay__menu',
				'walker' => new arcdeco_Topmenu_Walker(),
			) );

			?>
		</div>	
	</div>
	<!-- /Overlay nav -->
	<?php endif; ?>

	<?php 

	if ( $menu_type == 3 ) :
			
	wp_nav_menu( array(
		'theme_location' => 'primary',
		'container' => '',
		'menu_class' => 'sideNav',
		'walker' => new arcdeco_TopmenuSide_Walker(),
	) );

	?>
	<div class="overlay-sideNav"></div>
	<!-- Side Menu -->
	<?php endif; ?>

	<main class="main-container js-scroll">