<?php
/**
 * Ajax Infinite Scroll for Portfolio & Posts
 */

function arcdeco_infinite_scroll_scripts() {
	if ( is_page_template( 'template-portfolio.php' ) ) {

		$paginations = get_field( 'portfolio_paginations', 'option' );
		$page_id = get_the_id();

		if ( $paginations ) {
			/* query settings */
			$per_page = get_field( 'per_page' );
			if ( ! $per_page ) {
				$per_page = get_option( 'posts_per_page' );
			}

			$args = array(
				'post_type'		 => 'portfolio',
				'post_status'	   => 'publish',
				'posts_per_page'	=> $per_page
			);

			$q = new WP_Query($args);

			$data = array(
				'url'   => admin_url( 'admin-ajax.php' ),
				'max_num' => $q->max_num_pages,
				'page_id' => $page_id
			);

			wp_enqueue_script( 'arcdeco-portfolio-infinite-scroll', get_stylesheet_directory_uri() . '/assets/js/portfolio-infinite-scroll.js', array( 'jquery' ), '1.0', true );
			wp_localize_script( 'arcdeco-portfolio-infinite-scroll', 'ajax_portfolio_infinite_scroll_data', $data );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'arcdeco_infinite_scroll_scripts' );

function arcdeco_ajax_infinite_scroll() {
	$post_type = $_POST['post_type'];

	if ( $post_type == 'portfolio' ) {

		$page_id = $_POST['page_id'];
		$paged = $_POST['page_no'];
			
		$orderby = get_field( 'sort', $page_id );
		$per_page = get_field( 'per_page', $page_id );

		if ( ! $per_page ) {
			$per_page = get_option( 'posts_per_page' );
		}
		$order = 'ASC';
		
		if( ! $orderby ) {
			$orderby = 'date';
			$order = 'DESC';
		} elseif ( $orderby == 'date' ) {
			$order = 'DESC';
		}

		$args = array(
			'post_type'		 => 'portfolio',
			'post_status'	   => 'publish',
			'orderby'			=> $orderby,
			'order'				=> $order,
			'posts_per_page'	=> $per_page,
			'paged' 			=> $paged
		);

		$q = new WP_Query($args);
		
		if( $q->have_posts() ) :
			while( $q->have_posts() ) : $q->the_post();
				get_template_part( 'template-parts/content', get_post_type() );
			endwhile;

			wp_reset_postdata();
		endif;

		exit;

	}
}
add_action( 'wp_ajax_infinite_scroll', 'arcdeco_ajax_infinite_scroll' );
add_action( 'wp_ajax_nopriv_infinite_scroll', 'arcdeco_ajax_infinite_scroll' );

function arcdeco_ajax_infinite_scroll_el() {
	$post_type = $_POST['post_type'];

	if ( $post_type == 'portfolio' ) {

		$page_id = $_POST['page_id'];
		$paged = $_POST['page_no'];
			
		$orderby = $_POST['order_by'];
		$per_page = $_POST['per_page'];
		$order = $_POST['order'];
		$source = $_POST['source'];
		$temp = $_POST['temp'];
		$img_size = $_POST['img_size'];
		$cat_ids = $_POST['cat_ids'];

		$args = array(
			'post_type'		 => 'portfolio',
			'post_status'	   => 'publish',
			'orderby'			=> $orderby,
			'order'				=> $order,
			'posts_per_page'	=> $per_page,
			'paged' 			=> $paged
		);

		if( $source == 'categories' ) {
			$tax_array = array(
				array(
					'taxonomy' => 'portfolio_categories',
					'field'    => 'id',
					'terms'    => $cat_ids
				)
			);

			$args += array('tax_query' => $tax_array);
		}

		$q = new WP_Query($args);
		
		if( $q->have_posts() ) :
			while( $q->have_posts() ) : $q->the_post();
				set_query_var('img_size', $img_size);

				get_template_part( 'template-parts/content-' . $temp );
			endwhile;

			wp_reset_postdata();
		endif;

		exit;

	}
}
add_action( 'wp_ajax_infinite_scroll_el', 'arcdeco_ajax_infinite_scroll_el' );
add_action( 'wp_ajax_nopriv_infinite_scroll_el', 'arcdeco_ajax_infinite_scroll_el' );