<?php

function arcdeco_ocdi_import_files() {
    return array(
        array(
            'import_file_name'             => esc_attr__( 'Default', 'arcdeco' ),
            'categories'                   => array( esc_attr__( 'Main', 'arcdeco' ) ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/01/content.xml',
            //'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/01/widgets.json',
            //'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/01/customizer.dat',
            //'import_preview_image_url'     => get_template_directory_uri() . '/demo/01/preview.jpg',
            'preview_url'                  => esc_url( 'https://arcdeco.bslthemes.com/' ),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'arcdeco_ocdi_import_files' );

function arcdeco_ocdi_after_import_setup( $selected_import ) {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu Side', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'posts_per_page', 6 );

    $ocdi_fields_static = array(
    	'options_primary_font_family' => 0,
        '_options_primary_font_family' => 'field_5b68cfc4906fc',
        'options_text_font_family' => 0,
        '_options_text_font_family' => 'field_5b68d188906fd',
        'options_header_logo_img' => 7,
        '_options_header_logo_img' => 'field_5d11763c9ed10',
        'options_menu_type' => 3,
        '_options_menu_type' => 'field_5d2799da7df5b',
        'options_footer_text' => '<p>Phone: +1 (00) 123-45-67</p><p>Email: hello@acrdeco.com</p><p>Address: 756 Livingston Street, Brooklyn, NY 11201</p>',
        '_options_footer_text' => 'field_5b68cceac1b66',
        'options_social_links' => 3,
        '_options_social_links' => 'field_5b68ccabc1b63',
        'options_blog_title' => '',
        '_options_blog_title' => 'field_5e5e39b87f0e0',
        'options_post_page' => 127,
        '_options_post_page' => 'field_5d29eb446dca9',
        'options_blog_layout' => 1,
        '_options_blog_layout' => 'field_5e5cbfbdb2e1a',
        'options_blog_categories' => 1,
        '_options_blog_categories' => 'field_5b81b6d930cb9',
        'options_blog_excerpt' => 0,
        '_options_blog_excerpt' => 'field_5b81b7ca30cba',
        'options_social_share' => 'a:5:{i:0;s:8:"facebook";i:1;s:7:"twitter";i:2;s:8:"linkedin";i:3;s:6:"reddit";i:4;s:9:"pinterest";}',
        '_options_social_share' => 'field_5c610c399cf20',
        'options_portfolio_page' => '',
        '_options_portfolio_page' => 'field_5d29e1a48ac41',
        'options_portfolio_paginations' => 1,
        '_options_portfolio_paginations' => 'field_5d279aa756597',
        'options_p404_title' => 'Page not found...',
        '_options_p404_title' => 'field_5d180fd559b7f',
        'options_p404_content' => 'We are unable to find the page you are looking for.',
        '_options_p404_content' => 'field_5d180feb59b80',
        'options_bg_image' => 8,
        '_options_bg_image' => 'field_5d2a5bab8dc53',
        'options_social_links_0_icon' => 'fa fa-instagram',
        '_options_social_links_0_icon' => 'field_5d879352bc7a2',
        'options_social_links_0_url' => 'https://instagram.com/',
        '_options_social_links_0_url' => 'field_5b68ccd7c1b65',
        'options_social_links_1_icon' => 'fa fa-behance',
        '_options_social_links_1_icon' => 'field_5d879352bc7a2',
        'options_social_links_1_url' => 'https://behance.com/',
        '_options_social_links_1_url' => 'field_5b68ccd7c1b65',
        'options_social_links_2_icon' => 'fa fa-linkedin',
        '_options_social_links_2_icon' => 'field_5d879352bc7a2',
        'options_social_links_2_url' => 'https://linkedin.com/',
        '_options_social_links_2_url' => 'field_5b68ccd7c1b65',
    );
    $ocdi_fields_to_change = array();
    
    if( 'Default' === $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_primary_color' => '',
            '_options_primary_color' => 'field_5b68d5d8665da',
            'options_theme_ui' => 0,
            '_options_theme_ui' => 'field_5e5d0c42a91a1',
            'options_theme_color' => '',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_text_color' => '',
            '_options_text_color' => 'field_5b68d617665db',
            'options_btn_color' => '',
            '_options_btn_color' => 'field_5d28f4c767e3a',
            'options_wooshop_sidebar' => 'right',
            '_options_wooshop_sidebar' => 'field_5ed3dd51fa42f',
            'options_wooshop_parallax' => 1,
            '_options_wooshop_parallax' => 'field_5ed3e114e4aa4',
            'options_wooshop_parallax_img' => 177,
            '_options_wooshop_parallax_img' => 'field_5ed3e141e4aa5',
            'options_wooshop_parallax_title' => 'Shop',
            '_options_wooshop_parallax_title' => 'field_5ed3e169e4aa6',
            'options_wooshop_parallax_social' => 1,
            '_options_wooshop_parallax_social' => 'field_5ed3e185e4aa7',
        );
    }

    global $wpdb;
    foreach ( array_merge( $ocdi_fields_static, $ocdi_fields_to_change ) as $field => $value ) {
        if ( $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM $wpdb->options WHERE option_name = %s", $field ) ) == 0 ) {
            $wpdb->query( $wpdb->prepare( "INSERT INTO $wpdb->options ( option_name, option_value, autoload ) VALUES (%s, %s, 'no')", $field, $value ) );
        } else {
            $wpdb->query( $wpdb->prepare( "UPDATE $wpdb->options SET option_value = %s WHERE option_name = %s", $value, $field ) );
        }
    }

}
add_action( 'pt-ocdi/after_import', 'arcdeco_ocdi_after_import_setup' );