<?php
/**
 * Skin
**/

function arcdeco_hexToRgb( $hex ) {
	$hex = str_replace( '#', '', $hex );
	$length = strlen( $hex );
	$rgb['r'] = hexdec( $length == 6 ? substr( $hex, 0, 2 ) : ( $length == 3 ? str_repeat( substr( $hex, 0, 1), 2) : 0 ) );
	$rgb['g'] = hexdec( $length == 6 ? substr( $hex, 2, 2 ) : ( $length == 3 ? str_repeat( substr( $hex, 1, 1), 2) : 0 ) );
	$rgb['b'] = hexdec( $length == 6 ? substr( $hex, 4, 2 ) : ( $length == 3 ? str_repeat( substr( $hex, 2, 1), 2) : 0 ) );
	
	return implode( ", ", $rgb );
}

if ( function_exists( 'get_field' ) ) {
	/**
	 * Light Version
	 */

	$theme_ui = get_field( 'theme_ui', 'option' );

	if ( $theme_ui ) {
		function arcdeco_light_stylesheets() {
			wp_enqueue_style( 'arcdeco-light', get_template_directory_uri() . '/assets/styles/style-light.css', '1.0' );
		}
		add_action( 'wp_enqueue_scripts', 'arcdeco_light_stylesheets', 10 );
	}
}

function arcdeco_skin() {
	$theme_ui = get_field( 'theme_ui', 'option' );
	$theme_color = get_field( 'theme_color', 'options' );
	$primary_color = get_field( 'primary_color', 'options' );
	$text_color = get_field( 'text_color', 'options' );
	$btn_color = get_field( 'btn_color', 'options' );
	$primary_font_family = get_field( 'primary_font_family', 'options' );
	$text_font_family = get_field( 'text_font_family', 'options' );
	
	$header_logo_size = get_field( 'header_logo_size', 'options' );
	$header_logo_size_mob = get_field( 'header_logo_size_mob', 'options' );
	$preloader_logo_size = get_field( 'preloader_logo_size', 'options' );

	if ( $theme_ui ) {
		$primary_color = get_field( 'primary_color_light', 'options' );
		$text_color = get_field( 'text_color_light', 'options' );
	}

?>

<style>
	<?php if ( $text_color ) : ?>
	/* Paragraphs Color */
	body,
	.description,
	h1, 
	h2, 
	h3, 
	h4, 
	h5, 
	h6, 
	.title_news a, 
	.news__paragraph p, 
	.content-sidebar .widget-title, 
	.content-sidebar ul li a, 
	.content-sidebar ul li a.rsswidget,
	.post-edit-link,
	.wp-block-quote, 
	.wp-block-quote.is-large, 
	.wp-block-quote.is-style-large, 
	.wp-block-pullquote, 
	blockquote,
	.page-numbers, 
	.post-page-numbers,
	.input, 
	.textarea, 
	select,
	.custom-select,
	.input:focus, 
	.textarea:focus, 
	select:focus,
	.custom-select:focus,
	.form-control::-webkit-input-placeholder,
	.form-control::-moz-placeholder,
	.form-control:-ms-input-placeholder,
	.form-control::-ms-input-placeholder,
	.form-control::placeholder,
	.description,
	.foreword,
	.nav__link,
	.sideNav__item,
	.sideNav__item a,
	.sideNav__sub .sideNav__item a,
	.note .title,
	.content-grid__link:hover .content-grid__description,
	.content-grid .title,
	.content-grid__description, 
	.content-grid__role,
	.project-footer__link,
	.item-post-horizon__description,
	.post-footer .social__link,
	.comment-box__body,
	.footer,
	.footer__social a {
		color: <?php echo esc_attr( $text_color ); ?>;
	}
	<?php endif; ?>

	<?php if ( $primary_color ) : ?>
	/* Primary Color */
	h1,
	h2,
	h3,
	h4,
	h5,
	h6,
	.title_news a,
	.content-sidebar .widget-title,
	.title,
	.title--h1,
	.title--h2,
	.title--h3,
	.title--h4,
	.title--h5,
	.title--h6,
	.item-post-horizon__caption .title a {
		color: <?php echo esc_attr( $primary_color ); ?>;
	}
	<?php endif; ?>

	<?php if ( $theme_color ) : ?>
	/* Theme Color */
	.btn,
	.btn-link:hover,
	.btn-link,
	.title--tone,
	a,
	a:hover,
	.sideNav__item:hover,
	.sideNav__item a:hover,
	.sideNav__sub .sideNav__item a:hover,
	.social .social__link:hover,
	.slider .slider__caption .title--display-1,
	.item-post-horizon__caption .title a:hover,
	.post-footer .btn-link:hover,
	.tags-links a, 
	.col__sedebar .tagcloud a,
	.footer__social a:hover,
	.node.drag::before,
	.node.drag::after,
	.title_news a:hover,
	.page-numbers.current, 
	.post-page-numbers.current,
	.content-sidebar ul li a:hover,
	.woocommerce #respond input#submit, 
	.woocommerce a.button, 
	.woocommerce button.button, 
	.woocommerce input.button,
	.woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-mini-cart__buttons a.button, 
	.woocommerce-mini-cart__buttons button.button, 
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce-js #respond input#submit, 
	.woocommerce-js a.button, 
	.woocommerce-js button.button, 
	.woocommerce-js input.button,
	.woocommerce-js .woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-js .woocommerce-mini-cart__buttons a.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons button.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons input.button,
	.woocommerce .widget_price_filter .price_slider_amount .button:hover,
	.woocommerce-js .widget_price_filter .price_slider_amount .button:hover,
	.woocommerce .products div.product .button.add_to_cart_button,
	.woocommerce-js .products div.product .button.add_to_cart_button,
	.woocommerce nav.woocommerce-pagination ul li a:focus, 
	.woocommerce nav.woocommerce-pagination ul li a:hover, 
	.woocommerce nav.woocommerce-pagination ul li span.current,
	.woocommerce-js nav.woocommerce-pagination ul li a:focus, 
	.woocommerce-js nav.woocommerce-pagination ul li a:hover, 
	.woocommerce-js nav.woocommerce-pagination ul li span.current,
	.woocommerce .star-rating span:before,
	.woocommerce-js .star-rating span:before,
	.woocommerce div.product .button.single_add_to_cart_button,
	.woocommerce-js div.product .button.single_add_to_cart_button,
	.woocommerce #review_form #respond .form-submit .submit,
	.woocommerce-js #review_form #respond .form-submit .submit,
	#add_payment_method .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-cart .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,
	.woocommerce #respond input#submit.alt, 
	.woocommerce a.button.alt, 
	.woocommerce button.button.alt, 
	.woocommerce input.button.alt,
	.woocommerce-js #respond input#submit.alt, 
	.woocommerce-js a.button.alt, 
	.woocommerce-js button.button.alt, 
	.woocommerce-js input.button.alt,
	.product-categories .current-cat, 
	.product-categories .current-cat a,
	.woocommerce ul.product_list_widget li a.remove:hover, 
	ul.product_list_widget li a.remove:hover,
	.woocommerce-js ul.product_list_widget li a.remove:hover {
		color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.woocommerce .cart .button[name="update_cart"],
	.woocommerce-js .cart .button[name="update_cart"] {
		color: <?php echo esc_attr( $theme_color ); ?>!important;
	}
	.current-menu-item > a,
	.current-menu-item.nav-overlay__menu-item > a::before {
		color: <?php echo esc_attr( $theme_color ); ?>!important;
	}
	.navbar .angle svg path {
		fill: <?php echo esc_attr( $theme_color ); ?>;
	}
	.custom-control-input:checked~.custom-control-label::before,
	.btn::before,
	.touch .btn:hover,
	.touch .btn:focus,
	.btn-link:before,
	.title--separation::before,
	.title--separation-center::before,
	.preloader__progress span,
	.nav__link:hover::before,
	.post-footer .btn-link:hover::before,
	.post-footer .btn-link::before,
	.scroll-line,
	.cursor,
	body.woocommerce .widget_price_filter .ui-slider .ui-slider-range,
	body.woocommerce-js .widget_price_filter .ui-slider .ui-slider-range,
	body.woocommerce .widget_price_filter .ui-slider .ui-slider-handle,
	body.woocommerce-js .widget_price_filter .ui-slider .ui-slider-handle,
	.navbar .cart-btn .cart-icon .cart-count,
	.woocommerce .products div.product .button.add_to_cart_button:after,
	.woocommerce-js .products div.product .button.add_to_cart_button:after,
	.woocommerce div.product .button.single_add_to_cart_button:after,
	.woocommerce-js div.product .button.single_add_to_cart_button:after,
	.woocommerce #respond input#submit:after, 
	.woocommerce a.button:after, 
	.woocommerce button.button:after, 
	.woocommerce input.button:after,
	.woocommerce-js #respond input#submit:after, 
	.woocommerce-js a.button:after, 
	.woocommerce-js button.button:after, 
	.woocommerce-js input.button:after,
	.woocommerce .products .product .button.add_to_cart_button.added,
	.woocommerce-js .products .product .button.add_to_cart_button.added {
		background-color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.woocommerce #review_form #respond .form-submit .submit:hover, 
	.woocommerce-js #review_form #respond .form-submit .submit:hover {
		background-color: <?php echo esc_attr( $theme_color ); ?>!important;
	}
	.custom-control-input:focus:not(:checked)~.custom-control-label::before,
	.custom-control-input:checked~.custom-control-label::before,
	.btn,
	.tags-links a, 
	.col__sedebar .tagcloud a,
	.page-numbers.current, 
	.post-page-numbers.current,
	.woocommerce #respond input#submit, 
	.woocommerce a.button, 
	.woocommerce button.button, 
	.woocommerce input.button,
	.woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-mini-cart__buttons a.button, 
	.woocommerce-mini-cart__buttons button.button, 
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce-js #respond input#submit, 
	.woocommerce-js a.button, 
	.woocommerce-js button.button, 
	.woocommerce-js input.button,
	.woocommerce-js .woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-js .woocommerce-mini-cart__buttons a.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons button.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons input.button,
	.woocommerce .products div.product .button.add_to_cart_button,
	.woocommerce-js .products div.product .button.add_to_cart_button,
	.woocommerce div.product .button.single_add_to_cart_button,
	.woocommerce-js div.product .button.single_add_to_cart_button,
	.woocommerce #review_form #respond .form-submit .submit,
	.woocommerce-js #review_form #respond .form-submit .submit,
	#add_payment_method .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-cart .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button {
		border-color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.slider-prev:hover path,
	.slider-next:hover path {
		fill: <?php echo esc_attr( $theme_color ); ?>;
	}
	@media only screen and (min-width: 769px) {
		.filter__item.active a {
			color: <?php echo esc_attr( $theme_color ); ?>;
		}
	}
	::-moz-selection {
		color: <?php echo esc_attr( $theme_color ); ?>;
	}
	::selection {
		color: <?php echo esc_attr( $theme_color ); ?>;
	}

	.node {
		border-color: rgba(<?php echo esc_attr( arcdeco_hexToRgb( $theme_color ) ); ?>, 0.3);
	}
	.node.expand {
		background-color: rgba(<?php echo esc_attr( arcdeco_hexToRgb( $theme_color ) ); ?>, 0.2);
	}
	<?php endif; ?>

	<?php if ( $btn_color ) : ?>
	/* Buttons Color */
	.btn-link,
	.btn-link:hover,
	.btn,
	.woocommerce #respond input#submit, 
	.woocommerce a.button, 
	.woocommerce button.button, 
	.woocommerce input.button,
	.woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-mini-cart__buttons a.button, 
	.woocommerce-mini-cart__buttons button.button, 
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce-js #respond input#submit, 
	.woocommerce-js a.button, 
	.woocommerce-js button.button, 
	.woocommerce-js input.button,
	.woocommerce-js .woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-js .woocommerce-mini-cart__buttons a.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons button.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons input.button,
	.woocommerce .widget_price_filter .price_slider_amount .button:hover,
	.woocommerce-js .widget_price_filter .price_slider_amount .button:hover,
	.woocommerce .products div.product .button.add_to_cart_button,
	.woocommerce-js .products div.product .button.add_to_cart_button,
	.woocommerce div.product .button.single_add_to_cart_button,
	.woocommerce-js div.product .button.single_add_to_cart_button,
	.woocommerce #review_form #respond .form-submit .submit,
	.woocommerce-js #review_form #respond .form-submit .submit,
	#add_payment_method .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-cart .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,
	.woocommerce #respond input#submit.alt, 
	.woocommerce a.button.alt, 
	.woocommerce button.button.alt, 
	.woocommerce input.button.alt,
	.woocommerce-js #respond input#submit.alt, 
	.woocommerce-js a.button.alt, 
	.woocommerce-js button.button.alt, 
	.woocommerce-js input.button.alt,
	.woocommerce ul.product_list_widget li a.remove:hover, 
	ul.product_list_widget li a.remove:hover,
	.woocommerce-js ul.product_list_widget li a.remove:hover {
		color: <?php echo esc_attr( $btn_color ); ?>;
	}
	.woocommerce .cart .button[name="update_cart"],
	.woocommerce-js .cart .button[name="update_cart"] {
		color: <?php echo esc_attr( $btn_color ); ?>!important;
	}
	.btn-link:before,
	.btn::before,
	.touch .btn:hover,
	.touch .btn:focus,
	.woocommerce .products div.product .button.add_to_cart_button:after,
	.woocommerce-js .products div.product .button.add_to_cart_button:after,
	.woocommerce div.product .button.single_add_to_cart_button:after,
	.woocommerce-js div.product .button.single_add_to_cart_button:after,
	.woocommerce #respond input#submit:after, 
	.woocommerce a.button:after, 
	.woocommerce button.button:after, 
	.woocommerce input.button:after,
	.woocommerce-js #respond input#submit:after, 
	.woocommerce-js a.button:after, 
	.woocommerce-js button.button:after, 
	.woocommerce-js input.button:after,
	.woocommerce .products .product .button.add_to_cart_button.added,
	.woocommerce-js .products .product .button.add_to_cart_button.added {
		background-color: <?php echo esc_attr( $btn_color ); ?>;
	}
	.woocommerce #review_form #respond .form-submit .submit:hover, 
	.woocommerce-js #review_form #respond .form-submit .submit:hover {
		background-color: <?php echo esc_attr( $btn_color ); ?>!important;
	}
	.btn,
	.woocommerce #respond input#submit, 
	.woocommerce a.button, 
	.woocommerce button.button, 
	.woocommerce input.button,
	.woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-mini-cart__buttons a.button, 
	.woocommerce-mini-cart__buttons button.button, 
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce-js #respond input#submit, 
	.woocommerce-js a.button, 
	.woocommerce-js button.button, 
	.woocommerce-js input.button,
	.woocommerce-js .woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-js .woocommerce-mini-cart__buttons a.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons button.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons input.button,
	.woocommerce .products div.product .button.add_to_cart_button,
	.woocommerce-js .products div.product .button.add_to_cart_button,
	.woocommerce div.product .button.single_add_to_cart_button,
	.woocommerce-js div.product .button.single_add_to_cart_button,
	.woocommerce #review_form #respond .form-submit .submit,
	.woocommerce-js #review_form #respond .form-submit .submit,
	#add_payment_method .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-cart .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button {
		border-color: <?php echo esc_attr( $btn_color ); ?>;
	}
	<?php endif; ?>

	<?php if ( $text_font_family ) : ?>
	/* Paragraphs Font */
	body {
		font-family: '<?php echo esc_attr( $text_font_family['font_name'] ); ?>', serif;
	}
	<?php endif; ?>

	<?php if ( $primary_font_family ) : ?>
	/* Primary Font */
	h1,
	h2,
	h3,
	h4,
	h5,
	h6,
	.title_news a,
	.content-sidebar .widget-title,
	.title,
	.title--h1,
	.title--h2,
	.title--h3,
	.title--h4,
	.title--h5,
	.title--h6 {
		font-family: '<?php echo esc_attr( $primary_font_family['font_name'] ); ?>', serif;
	}
	<?php endif; ?>
	
	<?php if ( $header_logo_size ) : ?>
	.logo-link {
		max-width: <?php echo esc_attr( $header_logo_size ); ?>px;
	}
	<?php endif; ?>
	<?php if ( $header_logo_size_mob ) : ?>
	@media (max-width: 768px) {
		.logo-link {
			max-width: <?php echo esc_attr( $header_logo_size_mob ); ?>px;
		}
	}
	<?php endif; ?>
	<?php if ( $preloader_logo_size ) : ?>
	.preloader__logo, .preloader__wrap {
		max-width: <?php echo esc_attr( $preloader_logo_size ); ?>px;
	}
	<?php endif; ?>
</style>

<?php
}
add_action( 'wp_head', 'arcdeco_skin', 10 );