<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package arcdeco
 */

get_header();
?>

	<?php while ( have_posts() ) : the_post(); ?>

	<?php

	//post settings
	$subtitle = get_field( 'subtitle' );
	$subtitle_toggle = get_field( 'subtitle_toggle' );
	if ( ! $subtitle_toggle ) {
		$subtitle = 0;
	}
	$featured_video = get_field( 'featured_video' );
	$featured_video_toggle = get_field( 'featured_video_toggle' );
	if ( ! $featured_video_toggle ) {
		$featured_video = 0;
	}

	//content
	$image = get_the_post_thumbnail_url( get_the_ID(), 'arcdeco_1170x658' );
	
	//social share
	$social_share = get_field( 'social_share', 'options' );

	?>

	<!-- Blog Single -->
	<section class="section blog__single">
		<header class="header-post header-page">
		    <div class="container text-center">
			    <div class="row justify-content-center">
				    <div class="col-12 js-scroll-show">
		                <h1 class="title title--h1 title--separation-center"><?php the_title(); ?></h1>
					</div>
					<div class="col-12 col-lg-10 col-xl-8 js-scroll-show">
						<?php if ( $subtitle ) : ?>
						<p class="foreword">
							<?php echo wp_kses_post( $subtitle ); ?>
						</p>
						<?php endif; ?>
						<?php if ( get_post_type() == 'post' ) : ?>
					    <div class="post-details"><?php arcdeco_post_details(); ?></div>
						<?php endif; ?>
					</div>
			    </div>
			</div>
			<?php if ( $image && ! $featured_video ) : ?>
			<div class="image-gutter">
			    <div class="reveal-box">
			        <img class="cover" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>">
				    <span class="reveal-overlay"></span>
				</div>
			</div>
			<?php endif; ?>
			<?php if ( $featured_video ) : ?>
			<div class="image-gutter video-container js-video">
			    <div class="reveal-box">
                    <iframe class="js-video-iframe" data-src="https://www.youtube.com/embed/<?php echo esc_attr( $featured_video ); ?>?showinfo=0&rel=0&autoplay=1"></iframe>
			        <div class="video__poster js-image"<?php if ( $image ) : ?> data-image="<?php echo esc_attr( $image ); ?>"<?php endif; ?>>
				        <button class="video__btn" type="button"><?php echo esc_html__( 'PLAY', 'arcdeco' ); ?></button>
                    </div>
				    <span class="reveal-overlay"></span>
				</div>
	        </div>
	        <?php endif; ?>
		</header>
		
		<div class="container">

			<!-- Content -->
			<?php get_template_part( 'template-parts/content', 'single' ); ?>
			
			<!-- Footer post -->
			<footer class="post-footer">

				<!-- Post nav -->
				<?php 
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'arcdeco' ),
					'after'  => '</div>',
				) );
				?>

				<!-- Nav -->
				<?php arcdeco_post_navigantion(); ?>

				<!-- Share -->
				<?php if ( $social_share ) : ?>
				<div class="social social-share">
					<?php foreach ( $social_share as $social ) : ?>
					<a class="social__link share-btn share-btn-<?php echo esc_attr( $social['value'] ); ?>">
						<?php if ( $social['value'] == 'facebook' ) : ?>
						<i class="fa fa-facebook-f"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'twitter' ) : ?>
						<i class="fa fa-twitter"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'tumblr' ) : ?>
						<i class="fa fa-tumblr"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'linkedin' ) : ?>
						<i class="fa fa-linkedin"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'reddit' ) : ?>
						<i class="fa fa-reddit-alien" aria-hidden="true"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'pinterest' ) : ?>
						<i class="fa fa-pinterest-p"></i>
						<?php endif; ?>
						<?php if ( $social['value'] == 'whatsapp' ) : ?>
						<i class="fa fa-whatsapp"></i>
						<?php endif; ?>
					</a>
					<?php endforeach; ?>
				</div>
				<?php endif; ?>

			</footer>
			
			<?php if ( comments_open() || get_comments_number() ) : ?>
			<!-- Comments -->
			<div class="row justify-content-center">
				<div class="col-12 col-lg-10 col-xl-9">
					<?php
						// If comments are open or we have at least one comment, load up the comment template.
						comments_template();
					?>
				</div>	
			</div>
			<?php endif; ?>
		</div>

	</section>
	<!-- /Single -->

	<?php endwhile; ?>

<?php
get_footer();