<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package arcdeco
 */

?>

<?php

//options
$blog_categories = get_field( 'blog_categories', 'option' );
$blog_excerpt = get_field( 'blog_excerpt', 'option' );

//content
$image = get_the_post_thumbnail_url( get_the_ID(), 'arcdeco_1170x658' );
$categories_list = false;
if( $blog_categories ) {
	$categories_list = get_the_category();
}

?>

<article class="item__news">
	<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if ( $image ) : ?>
		<figure class="media-content">
			<span class="reveal">
				<a href="<?php echo esc_url( get_permalink() ); ?>">
					<img class="news-image" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>">
				</a>
			</span>
		</figure>
		<?php endif; ?>
		<div class="news__paragraph">
			<div class="detail__news">
				<?php 

				if ( $categories_list ) {
					$total = count( $categories_list );
					$i = 0;
					foreach ( $categories_list as $category ) { $i++;
						if ( $total != $i ) {
							echo esc_html( $category->cat_name ) . ', ';
						} else {
							echo esc_html( $category->cat_name );
						}
					}
					echo esc_html( ' / ', 'arcdeco' );
				}
				if ( ! empty( get_the_title() ) ) {
					echo esc_html( get_the_date() );
				} else {
					echo '<a class="date" href="' . esc_url( get_the_permalink() ) . '">' . esc_html( get_the_date() ) . '</a>';
				}

				?>
			</div>
			<h2 class="title title--h4 title_news"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h2>
			
			<?php if ( ! $blog_excerpt ) : ?>
				<?php the_excerpt(); ?>
			<?php endif; ?>
		</div>
	</div><!-- #post-<?php the_ID(); ?> -->
</article>