<?php
/**
 * Template Name: Portfolio
 *
 * @package arcdeco
*/

get_header(); 
?>
	
<?php

/* get content */
$page_id = get_the_ID();
$title = get_field( 'title' );
if ( ! $title ) {
	$title = get_the_title();
}

/* get options */
$filters = get_field( 'filters' );
$paginations = get_field( 'portfolio_paginations', 'option' );

/* get categories */
$portfolio_categories = arcdeco_get_categories( 'portfolio_categories' );

/* query settings */
$orderby = get_field( 'sort' );
$per_page = get_field( 'per_page' );
if ( ! $per_page ) {
	$per_page = get_option( 'posts_per_page' );
}
$order = 'ASC';
$paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;

if( ! $orderby ) {
	$orderby = 'date';
	$order = 'DESC';
} elseif ( $orderby == 'date' ) {
	$order = 'DESC';
}

$args = array(
	'post_type'		 => 'portfolio',
	'post_status'	   => 'publish',
	'paged' 			=> $paged,
	'orderby'			=> $orderby,
	'order'				=> $order,
	'posts_per_page'	=> $per_page
);

$q = new WP_Query($args);

?>

<div class="container">
    <header class="header-page">
        <h1 class="title title--h1 js-lines"><?php echo esc_html( $title ); ?></h1>
        
        <?php if ( $filters && $portfolio_categories ) : ?>
        <!-- Filter -->
        <div class="select js-down-done">
	        <span class="placeholder"><?php echo esc_html__( 'Select category', 'arcdeco' ); ?></span>
	        <ul class="filter">
	            <li class="filter__item"><?php echo esc_html__( 'Category', 'arcdeco' ); ?></li>
		        <li class="filter__item active" data-filter="*"><a class="filter__link active" href="#filter"><?php echo esc_html__( 'All', 'arcdeco' ); ?></a></li>
		        <?php foreach ( $portfolio_categories as $category ) : ?>
		        <li class="filter__item" data-filter=".category-<?php echo esc_attr( $category->slug ); ?>"><a class="filter__link" href="#filter"><?php echo esc_html( $category->name ); ?></a></li>
		        <?php endforeach; ?>
	        </ul>
	        <input type="hidden" name="changemetoo"/>
        </div>
        <?php endif; ?>
    </header>

    <?php if ( $q->have_posts() ) : ?>
    <div class="content-grid project-masonry filter-container">
        <div class="gutter-sizer"></div>

        <?php while ( $q->have_posts() ) : $q->the_post();
			get_template_part( 'template-parts/content', get_post_type() );
		endwhile; ?>			
    </div>
    <?php if ( ! $paginations ) : ?>
    	<div class="pager">
    		<?php
			$big = 999999999; // need an unlikely integer

			echo paginate_links( array(
				'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
				'format' => '?paged=%#%',
				'current' => max( 1, get_query_var('paged') ),
				'total' => $q->max_num_pages,
				'prev_text' => esc_html__( 'Prev', 'arcdeco' ),
				'next_text' => esc_html__( 'Next', 'arcdeco' ),
			) ); ?>
		</div>
		<?php endif;
	else :
    	get_template_part( 'template-parts/content', 'none' );
	endif; wp_reset_postdata(); ?>
</div>
	
<?php
get_footer();