<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Arcdeco About Heading Widget.
 *
 * @since 1.0
 */
class Arcdeco_Project_Description_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-project-description';
	}

	public function get_title() {
		return esc_html__( 'Project Description', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return 'fas fa-align-justify';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'arcdeco-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'arcdeco-plugin' ),
				'default'     => esc_html__( 'Enter title', 'arcdeco-plugin' ),
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'arcdeco-plugin' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Enter Description', 'arcdeco-plugin' ),
				'default'     => esc_html__( 'Enter Description', 'arcdeco-plugin' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'arcdeco-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'arcdeco-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .project-description__text .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .project-description__title .title',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'description_styling',
			[
				'label'     => esc_html__( 'Description', 'arcdeco-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'description_color',
			[
				'label'     => esc_html__( 'Color', 'arcdeco-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .project-description__text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'description_typography',
				'selector' => '{{WRAPPER}} .project-description__text',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'description', 'advanced' );

		?>

		<div class="container project-description">
		    <!-- Description -->
		    <div class="row justify-content-center content-caption">
			    <div class="col-12 col-lg-4 project-description__title">
			    	<?php if ( $settings['title'] ) : ?>
				    <h2 class="title title--h5 js-lines">
				    	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
				    		<?php echo wp_kses_post( $settings['title'] ); ?>
				    	</span>
				    </h2>
				    <?php endif; ?>
				</div>
			    <div class="col-12 col-lg-8 js-scroll-show project-description__text">
				    <?php if ( $settings['description'] ) : ?>
			    	<div <?php echo $this->get_render_attribute_string( 'description' ); ?>>
			    		<?php echo wp_kses_post( $settings['description'] ); ?>
			    	</div>
				    <?php endif; ?>
				</div>
			</div>
		</div>

		<?php 
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template() { ?>
		
		<#
		view.addInlineEditingAttributes( 'title', 'basic' );
		view.addInlineEditingAttributes( 'description', 'advanced' );
		#>

		<div class="container project-description">
		    <!-- Description -->
		    <div class="row justify-content-center content-caption">
			    <div class="col-12 col-lg-4 project-description__title">
			    	<# if( settings.title ) { #>
				    <h2 class="title title--h5 js-lines">
			    		<span {{{ view.getRenderAttributeString( 'title' ) }}}>{{{ settings.title }}}</span>
			    	</h2>
				    <# } #>
				</div>
			    <div class="col-12 col-lg-8 js-scroll-show project-description__text">
				    <# if( settings.description ) { #>
			    	<div {{{ view.getRenderAttributeString( 'description' ) }}}>{{{ settings.description }}}</div>
				    <# } #>
				</div>
			</div>
		</div>

	<?php }
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_Project_Description_Widget() );