<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package arcdeco
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<!-- Comments -->
<div id="comments" class="section__comments">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
		?>
		
		<h3 class="title title--h5"><?php comments_number( esc_html__( 'No comments found', 'arcdeco' ), esc_html__( '1 Comment', 'arcdeco' ), esc_html__( '% Comments', 'arcdeco' ) ); ?></h3>

		<ul class="comments">
			<?php
			wp_list_comments( array(
				'style'	  => 'ul',
				'avatar_size' => '80',
				'callback' => 'arcdeco_comment'
			) );
			?>
		</ul><!-- .comment-list -->

		<?php
		the_comments_navigation( array(
			'screen_reader_text' => ' ',
			'prev_text' => esc_html__( 'Older comments', 'arcdeco' ),
			'next_text' => esc_html__( 'Newer comments', 'arcdeco' )
		) );

		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() ) :
			?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'arcdeco' ); ?></p>
			<?php
		endif;

	endif; // Check for have_comments().
	?>
	
	<div class="form-comment">
		<?php
			$req = get_option( 'require_name_email' );
			$aria_req = ( $req ? " aria-required='true'" : '' );
		
			$comment_args = array(
				'title_reply' => esc_html__( 'Leave a comment', 'arcdeco' ),
				'title_reply_to' => esc_html__( 'Leave a comment to %s', 'arcdeco' ),
				'cancel_reply_link' => esc_html__( 'Cancel Reply', 'arcdeco' ),
				'title_reply_before' => '<h3 class="title title--h5">',
				'title_reply_after' => '</h3>',
				'label_submit' => esc_html__( 'Submit', 'arcdeco' ),
				'comment_field' => '<div class="row"><div class="form-group col-12"><textarea class="textarea form-control" rows="3" placeholder="' . esc_attr__( 'Comment', 'arcdeco' ).'" id="comment" name="comment" aria-required="true" ></textarea></div></div>',
				'must_log_in' => '<p class="must-log-in">' . esc_html__( 'You must be ', 'arcdeco' ) . '<a href="' . esc_url( wp_login_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '">' . esc_html__( 'logged in', 'arcdeco' ) . '</a>' . esc_html__( ' to post a comment.', 'arcdeco' ) . '</p>',
				'logged_in_as' => '<p class="logged-in-as">' . esc_html__( 'Logged in as ', 'arcdeco' ) . '<a href="' . esc_url( admin_url( 'profile.php' ) ) . '">' . esc_html( $user_identity ) . '</a>' . esc_html__( '. ', 'arcdeco' ) . '<a href="' . esc_url( wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '" title="' . esc_attr__( 'Log out of this account', 'arcdeco' ) . '">' . esc_html__( 'Log out?', 'arcdeco' ) . '</a></p>',
				'comment_notes_before' => '',
				'comment_notes_after' => '',
				'fields' => apply_filters( 'comment_form_default_fields', array(
					'author' => '<div class="row"><div class="form-group col-12 col-md-6"><input id="author" name="author" type="text" placeholder="' . esc_attr__( 'Name', 'arcdeco' ) . '" class="input form-control" value="" ' . $aria_req . ' /></div>',
					'email' => '<div class="form-group col-12 col-md-6"><input id="email" name="email" type="text" placeholder="' . esc_attr__( 'Email', 'arcdeco' ) . '" class="input form-control" value="" ' . $aria_req . ' /></div></div>',
				)),
				'class_submit' => 'btn btn_effect',
				'submit_field' => ' <div class="row"><div class="col-md-12">%1$s %2$s</div></div>',
				'submit_button' => '<button type="submit" name="%1$s" id="%2$s" class="%3$s">%4$s</button>'
			);

			comment_form( $comment_args );
		?>
	</div>

</div><!-- #comments -->
