<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package arcdeco
 */

get_header();
?>

<?php

	/*get options*/
	$layout = get_field( 'blog_layout', 'option' );

	?>

	<div class="container">
        <header class="header-page header-page-posts">
            <h1 class="title title--h1 js-lines"><?php printf( esc_html__( 'Search: %s', 'arcdeco' ), get_search_query() ); ?></h1>
	    </header>
	    
	    <?php if ( $layout == 0 ) : ?>
	    <div class="news__wrap__fullwidth _sedibar">
			<div class="row">
				<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
				<div class="col-md-9">
				<?php else : ?>
				<div class="col-md-12">
				<?php endif; ?>
				<div class="articles-container">
		<?php endif; ?>
		<?php if ( $layout == 1 ) : ?>
		<div class="articles-container">
        <?php endif; ?>
		<?php if ( $layout == 2 ) : ?>
		<div class="articles-container">
		<div class="content-grid news-masonry filter-container">
                <div class="gutter-sizer-two"></div>
        <?php endif; ?>

	    <?php if ( have_posts() ) :
			while ( have_posts() ) : the_post();
				get_template_part( 'template-parts/content', 'search' );
			endwhile;
		?>

		<?php if ( $layout == 2 ) : ?></div><?php endif; ?>
		</div>

		<div class="pager">
			<?php
				echo paginate_links( array(
					'prev_text'		=> esc_html__( 'Prev', 'arcdeco' ),
					'next_text'		=> esc_html__( 'Next', 'arcdeco' ),
				) );
			?>
		</div>
		<?php else : ?>
			<?php get_template_part( 'template-parts/content', 'none' ); ?>
			</div>
		<?php endif; ?>

		<?php if ( $layout == 0 ) : ?>
		</div>
			<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
			<div class="col-md-3">
				<div class="col__sedebar">
					<?php get_sidebar(); ?>
				</div>
			</div>
			<?php endif; ?>
		</div>
		</div>
		<?php endif; ?>
	</div>

<?php
get_footer();