<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Arcdeco Gallery Image Widget.
 *
 * @since 1.0
 */
class Arcdeco_Gallery_Image_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-gallery-image';
	}

	public function get_title() {
		return esc_html__( 'Gallery Image', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return 'fas fa-images';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Image', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image',
			[
				'label'       => esc_html__( 'Image', 'arcdeco-plugin' ),
				'type'        => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() { 
		$settings = $this->get_settings_for_display(); 

		if ( $settings['image'] ) :
			$image = wp_get_attachment_image_url( $settings['image']['id'], 'arcdeco_1920xAuto' );
		?>


        <!-- Gallery Item -->
		<div class="gallery__item reveal-box">
		    <img class="cover lazyload zoom-cursor" src="<?php echo esc_url( $image ); ?>" data-zoomable alt="<?php echo esc_attr__( 'Image', 'arcdeco-plugin' ); ?>" />
		    <span class="reveal-overlay"></span>
	    </div>

		<?php endif;
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template() {
		?>
        
        <!-- Gallery Item -->
		<div class="gallery__item reveal-box">
		    <img class="cover lazyload" src="{{{ settings.image.url }}}" alt="" />
		    <span class="reveal-overlay"></span>
	    </div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_Gallery_Image_Widget() );