<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Arcdeco About Heading Widget.
 *
 * @since 1.0
 */
class Arcdeco_Project_Started_Widget extends Widget_Base {

	public function get_name() {
		return 'arcdeco-project-started';
	}

	public function get_title() {
		return esc_html__( 'Project Started', 'arcdeco-plugin' );
	}

	public function get_icon() {
		return 'fab fa-stripe-s';
	}

	public function get_categories() {
		return [ 'arcdeco-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'arcdeco-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'arcdeco-plugin' ),
				'default'     => esc_html__( 'Title', 'arcdeco-plugin' ),
			]
		);

		$this->add_control(
			'image',
			[
				'label'       => esc_html__( 'Image', 'arcdeco-plugin' ),
				'type'        => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'social_tab',
			[
				'label' => esc_html__( 'Social', 'arcdeco-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);	

		$this->add_control(
			'social',
			[
				'label' => esc_html__( 'Show Social', 'arcdeco-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'arcdeco-plugin' ),
				'label_off' => esc_html__( 'Hide', 'arcdeco-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label'     => esc_html__( 'Project Started', 'arcdeco-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'arcdeco-plugin' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'arcdeco-plugin' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'arcdeco-plugin' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'arcdeco-plugin' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'default' => 'left',
				'prefix_class' => 'elementor-align%s-',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'arcdeco-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'arcdeco-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .hero__header .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .hero__header .title',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$this->add_inline_editing_attributes( 'title', 'basic' );

		$social_links = get_field( 'social_links', 'option' );

		?>

		<header class="hero overlay--45">
		    <div class="hero__header align-items-center">
		    	<?php if ( $settings['title'] ) : ?>
			    <h1 class="title title--display-1 text-center js-words">
			    	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
                		<?php echo wp_kses_post( $settings['title'] ); ?>
                	</span>
			    </h1>
			    <?php endif; ?>
			</div>
			
			<?php if ( $settings['social'] == 'yes' && $social_links ) : ?>
			<!-- Social -->
			<div class="social social-floating">
				<?php foreach ( $social_links as $social_link ) : ?>
		        <a class="social__link" href="<?php echo esc_url( $social_link['url'] ); ?>" target="_blank"><i class="<?php echo esc_attr( $social_link['icon'] ); ?>"></i></a>
		    	<?php endforeach; ?>
		    </div>
		    <?php endif; ?>

			<?php if ( $settings['image'] ) : $image = wp_get_attachment_image_url( $settings['image']['id'], 'arcdeco_1920xAuto' ); ?>
            <img class="hero__image cover js-scale js-parallax" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>" />
            <?php endif; ?>
		</header>

		<?php 
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _content_template() { ?>
		
		<#
		view.addInlineEditingAttributes( 'title', 'basic' );
		#>

		<header class="hero overlay--45">
		    <div class="hero__header align-items-center">
		    	<# if( settings.title ) { #>
			    <h1 class="title title--display-1 text-center js-words">
			    	<span {{{ view.getRenderAttributeString( 'title' ) }}}>{{{ settings.title }}}</span>
			    </h1>
			    <# } #>
			</div>

			<# if( settings.image ) { #>
            <img class="hero__image cover js-scale js-parallax" src="{{{ settings.image.url }}}" alt="" />
            <# } #>
		</header>

	<?php }
}

Plugin::instance()->widgets_manager->register_widget_type( new Arcdeco_Project_Started_Widget() );