<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsProject extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-project';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Project', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Project widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Project widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'project' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Project', 'bdevs-elementor' ),
			]	
		);

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Subheading', 'bdevs-elementor' ),
				'default'		=> __('This is subheading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Heading', 'bdevs-elementor' ),
				'default'     => __( 'This is heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'bdevs-elementor' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => __( 'Content', 'bdevs-elementor' ),
				'default'     => __( 'This is content', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Project Count', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your count', 'bdevs-elementor' ),
				'default'   => '6',
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings);	
		$post_number = $settings['post_number'];
	    $order = $settings['post_order'];
	    $wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'project',  'orderby' => 'ID', 'order' => $order));
	   
	    //other style
	    $args = array('posts_per_page' => $post_number,'post_type' => 'project',  'orderby' => 'ID', 'order' => $order);	
	   	?>
	   	<div class="section-padding">
	        <div class="container">
	            <div class="row">
	                <div class="col-md-3 mb-30 animate-box" data-animate-effect="fadeInLeft">
	                    <?php if ( $settings['show_subheading'] ) : ?>
	                    <span><?php print wp_kses_post($settings['subheading']); ?></span>
	                	<?php endif; ?>
	                    <?php if ( $settings['show_heading'] ) : ?>
	                    <h2><?php print wp_kses_post($settings['heading']); ?></h2>
	                    <?php endif; ?>
	                </div>
	            </div>
	            <?php if ( $settings['show_content'] ) : ?>
	            <div class="row">
	                <div class="col-md-12">
	                    <div class="row">
	                       <div class="col-md-2"> <span class="line-one"></span> </div>
	                        <div class="col-md-8 mb-30">
	                            <?php print wp_kses_post($settings['content']); ?>
	                        </div>
	                    </div>
	                </div>
	            </div>
	            <?php endif; ?>
	            <div class="row text-center">
	                <ul class="arcprime-project-filter">
	                    <li class="active" data-filter="*"><?php echo esc_html__( 'All', 'arcprime' );?></li>
	                    <?php 

                            $categories = get_terms('type2');   

                             foreach( (array)$categories as $categorie){

                                $cat_name = $categorie->name;

                                $cat_slug = $categorie->slug;

                        ?>
	                    <li data-filter=".<?php echo esc_attr($cat_slug);?>"><?php echo esc_attr($cat_name);?></li>
	                    <?php } ?>
	                </ul>
	            </div>
	            <div class="row arcprime-project-items">
	            	<?php
		                $args = new \WP_Query(array(   
		                            'post_type' => 'project', 
		                        ));  
		                while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
		                $cates = get_the_terms(get_the_ID(),'type2');

		                    $cate_name ='';

		                    $cate_slug = '';

		                    foreach((array)$cates as $cate){

		                        $cate_name .= $cate->name.'  ' ;

		                        $cate_slug .= $cate->slug .' '; 

		                } 
		                $project_subtitle = get_post_meta(get_the_ID(),'_cmb_project_subtitle', true); 
		                $project_image_2 = get_post_meta(get_the_ID(),'_cmb_project_image_2', true); 
		            ?>
	                <div class="col-md-6 single-item <?php echo esc_attr($cate_slug);?>">
	                    <div class="arcprime-project-wrap"> 
	                       <a href="<?php the_permalink(); ?>"><img src="<?php print wp_get_attachment_url($project_image_2); ?>" alt=""></a>
	                        <div class="arcprime-project-content">
	                            <p><?php echo esc_attr($project_subtitle); ?></p>
	                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
	                            <a href="<?php the_permalink(); ?>" class="arcprime-project-link"></a>
	                        </div>
	                    </div>
	                </div>
	                <?php   
				        endwhile; 
				        wp_reset_postdata();
				    ?>
	            </div>
	            
	        </div>
	    </div>
	<?php
	}

}