<?php


// register post type2 Project

add_action( 'init', 'register_arcprime_Project' );

function register_arcprime_Project() {

    

    $labels = array( 

        'name' => __( 'Project', 'arcprime' ),

        'singular_name' => __( 'Project', 'arcprime' ),

        'add_new' => __( 'Add New Project', 'arcprime' ),

        'add_new_item' => __( 'Add New Project', 'arcprime' ),

        'edit_item' => __( 'Edit Project', 'arcprime' ),

        'new_item' => __( 'New Project', 'arcprime' ),

        'view_item' => __( 'View Project', 'arcprime' ),

        'search_items' => __( 'Search Project', 'arcprime' ),

        'not_found' => __( 'No Project found', 'arcprime' ),

        'not_found_in_trash' => __( 'No Project found in Trash', 'arcprime' ),

        'parent_item_colon' => __( 'Parent Project:', 'arcprime' ),

        'menu_name' => __( 'Project', 'arcprime' ),

    );



    $args = array( 

        'labels' => $labels,

        'hierarchical' => true,

        'description' => 'List Project',

        'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),

        'taxonomies' => array( 'Project', 'type2' ),

        'public' => true,

        'show_ui' => true,

        'show_in_menu' => true,

        'menu_position' => 5,

        'menu_icon' => 'dashicons-portfolio', 

        'show_in_nav_menus' => true,

        'publicly_queryable' => true,

        'exclude_from_search' => false,

        'has_archive' => true,

        'query_var' => true,

        'can_export' => true,

        'rewrite' => true,

        'capability_type' => 'post'

    );



    register_post_type( 'Project', $args );

}

add_action( 'init', 'create_type2_hierarchical_taxonomy', 0 );



//create a custom taxonomy name it Skillss for your posts



function create_type2_hierarchical_taxonomy() {



// Add new taxonomy, make it hierarchical like Skills

//first do the translations part for GUI



  $labels = array(

    'name' => __( 'Type', 'arcprime' ),

    'singular_name' => __( 'Type', 'arcprime' ),

    'search_items' =>  __( 'Search Type','arcprime' ),

    'all_items' => __( 'All Type','arcprime' ),

    'parent_item' => __( 'Parent Type','arcprime' ),

    'parent_item_colon' => __( 'Parent Type:','arcprime' ),

    'edit_item' => __( 'Edit Type','arcprime' ), 

    'update_item' => __( 'Update Type','arcprime' ),

    'add_new_item' => __( 'Add New Type','arcprime' ),

    'new_item_name' => __( 'New Type Name','arcprime' ),

    'menu_name' => __( 'Type','arcprime' ),

  );     



// Now register the taxonomy



  register_taxonomy('type2',array('Project'), array(

    'hierarchical' => true,

    'labels' => $labels,

    'show_ui' => true,

    'show_admin_column' => true,

    'query_var' => true,

    'rewrite' => array( 'slug' => 'type2' ),

  ));



}



?>