<?php
/**
 * The template for displaying 404 pages (Not Found)
 */
    $arcprime_redux_demo = get_option('redux_demo');
    get_header('dark'); 
?> 
<!-- Banner Title -->
<?php if(isset($arcprime_redux_demo['404_image']['url']) && $arcprime_redux_demo['404_image']['url'] != ''){?>
<div class="ready banner-padding bg-img bg-dark" data-overlay-dark="2" data-background="<?php echo esc_url($arcprime_redux_demo['404_image']['url']); ?>">
<?php }else{?> 
<div class="ready banner-padding bg-img bg-dark" data-overlay-dark="2" data-background="<?php echo get_template_directory_uri();?>/images/banner-2-dark.jpg">
<?php } ?>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="text-center">
                    <div class="title animate-box" data-animate-effect="fadeInUp">
                        <h1><?php if(isset($arcprime_redux_demo['404_title'])){?>
                            <?php echo wp_specialchars_decode(esc_attr($arcprime_redux_demo['404_title']));?>
                            <?php }else{?>
                            <?php echo esc_html__( '404 Page', 'arcprime' );
                            }
                            ?>
                        </h1>
                        <h4>
                          <?php if(isset($arcprime_redux_demo['404_subtitle'])){?>
                          <?php echo wp_specialchars_decode(esc_attr($arcprime_redux_demo['404_subtitle']));?>
                          <?php }else{?>
                          <?php echo esc_html__( 'Oops! The Page not found.', 'arcprime' );
                          }
                          ?>
                        </h4>
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="arcprime-btnn">
                          <?php if(isset($arcprime_redux_demo['404_button'])){?>
                          <?php echo wp_specialchars_decode(esc_attr($arcprime_redux_demo['404_button']));?>
                          <?php }else{?>
                          <?php echo esc_html__( 'Back To Home', 'arcprime' );
                          }
                          ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
  get_footer('dark');
?> 