<!doctype html>
<html class="no-js" <?php language_attributes(); ?>>
<?php $arcprime_redux_demo = get_option('redux_demo'); ?>
    <head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if(isset($arcprime_redux_demo['favicon']['url'])){ ?>
        <link rel="shortcut icon" href="<?php echo esc_url($arcprime_redux_demo['favicon']['url']); ?>">
    <?php }?>
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
        ?>
    <?php }?>
    <?php wp_head(); ?>
    </head>
    <body id="post-<?php the_ID(); ?>" <?php post_class(' dark '); ?>>

        <!-- Preloader -->
        <div id="arcprime-page-loading" class="arcprime-pageloading">
            <div class="arcprime-pageloading-inner">
                <a class="arcprime-pageloading" href="<?php echo esc_url(home_url('/')); ?>"> 
                    <?php if(isset($arcprime_redux_demo['preloader_dark']['url']) && $arcprime_redux_demo['preloader_dark']['url'] != ''){ ?>
                    <img src="<?php echo esc_url($arcprime_redux_demo['preloader_dark']['url']); ?>" alt="">
                    <?php }else{ ?>
                    <img src="<?php echo get_template_directory_uri();?>/images/logo-dark.png" alt="">
                    <?php } ?> 
                </a> 
            </div>
        </div>
        <!-- Header -->
        <header>
            <div class="arcprime-header-navbar">
                <div class="container arcprime-navbar-container">
                    <div class="arcprime-navigation-wrap bg-light arcprime-start-header start-style">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12">
                                    <nav class="navbar navbar-expand-md navbar-light">
                                        <!-- Logo -->
                                        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                                            <?php if(isset($arcprime_redux_demo['logo_dark']['url']) && $arcprime_redux_demo['logo_dark']['url'] != ''){ ?>
                                            <img src="<?php echo esc_url($arcprime_redux_demo['logo_dark']['url']); ?>" alt="Logo">
                                            <?php }else{ ?>
                                            <img src="<?php echo get_template_directory_uri();?>/images/logo-dark.png" alt="Logo">
                                            <?php } ?> 
                                        </a>
                                        <!-- Menu -->
                                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"> <span class="navbar-toggler-icon"></span> </button>
                                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                                            <?php 
                                              wp_nav_menu( 
                                              array( 
                                                    'theme_location' => 'dark',
                                                    'container' => '',
                                                    'menu_class' => '', 
                                                    'menu_id' => '',
                                                    'menu'            => '',
                                                    'container_class' => '',
                                                    'container_id'    => '',
                                                    'echo'            => true,
                                                    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                                                    'walker'            => new arcprime_wp_bootstrap_navwalker(),
                                                    'before'          => '',
                                                    'after'           => '',
                                                    'link_before'     => '',
                                                    'link_after'      => '',
                                                    'items_wrap'      => '<ul id="nav" class="navbar-nav ml-auto py-4 py-md-0 %2$s">%3$s</ul>',
                                                    'depth'           => 0,        
                                                )
                                            ); ?>
                                        </div>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>