<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package hellix
 */

get_header();

$link_text = apply_filters( 'hellix_404_link_text', get_theme_mod( '404_link_text', esc_html__( 'BACK TO HOMEPAGE', 'hellix' ) ) );
$button    = apply_filters( 'hellix_404_button', get_theme_mod( 'button_varient', 'accent' ) );

$text_color = 'white';
if ( 'white' === $button ) {
	$text_color = 'dark';
}

$img_url = wp_get_attachment_image(
	get_theme_mod( '404_image_url' ),
	'480px',
	false,
	array(
		'class' => 'bg-image js-lazy',
		'alt'   => esc_attr__( 'Page Not Found', 'hellix' ),
	)
);

?>

<section class="no-page">
	<div data-parallax="0.6" class="no-page__bg">
		<?php
		if ( '' !== $img_url ) :
			echo wp_kses_post( apply_filters( 'hellix_404_image_url', $img_url ) );
		else :
			?>
		<div data-parallax-target class="bg-image js-lazy" data-bg="<?php echo esc_url( get_template_directory_uri() . '/assets/img/backgrounds/6.jpg' ); ?>"></div>
			<?php
		endif;
		?>
	</div>

	<div class="container">
		<div class="row justify-content-center align-items-center">
			<div class="col-xl-5 col-lg-8 col-md-10">
				<div class="no-page__content">
					<?php if ( get_theme_mod( '404_title' ) !== '' ) : ?>
					<h1 class="no-page__title text-white"><?php echo esc_html( get_theme_mod( '404_title', _x( '404', 'front-end', 'hellix' ) ) ); ?></h1>
				<?php endif; ?>

				<?php if ( get_theme_mod( '404_subtitle' ) !== '' ) : ?>
					<p class="no-page__text text-white mt-8">
						<?php echo esc_html( get_theme_mod( '404_subtitle', _x( 'Oops! That page can’t be found.', 'front-end', 'hellix' ) ) ); ?>
					</p>
				<?php endif; ?>

					<div class="no-page__button mt-64 md:mt-48">
						<a data-barba href="<?php echo esc_url( home_url( '/' ) ); ?>" class="button -md -<?php echo esc_attr( $button ); ?> text-<?php echo esc_attr( apply_filters( 'hellix_404_button_color', $text_color ) ); ?>"><?php echo esc_html( $link_text ); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php
wp_footer();
