<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package hellix
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}

$class_comments = 'blogPost -comments pt-60';
if ( is_page() ) {
	$class_comments .= ' max-w-[75%]';
	if ( ! hellix_is_extensions_activated() ) {
		$class_comments .= ' mx-auto';
	}
}
?>
<div class="<?php echo esc_attr( $class_comments ); ?>">
	<?php
	if ( have_comments() ) :
		?>
		<div class="blogPost__content mb-60 md:mb-40">
			<h2 class="blogPost__title text-2xl fw-600">
				<?php
				// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
				echo sprintf(
					/* translators: 1: number of comments, 2: post title */
					esc_html( _nx( '%1$s Comment', '%1$s Comments', get_comments_number(), 'comments title', 'hellix' ) ),
					number_format_i18n( get_comments_number() )
				);
				// phpcs:enable
				?>
			</h2>
			<ul class="comments__list mt-40 pl-0">
				<?php
				wp_list_comments(
					array(
						'style'      => 'ul',
						'short_ping' => true,
						'callback'   => 'hellix_comment',
					)
				);
				?>

			</ul>
		</div>

		<?php
		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through.
			?>
			<nav id="comment-nav-below" class="comment-navigation mb-40 md:mb-20" role="navigation" aria-label="<?php esc_attr_e( 'Comment Navigation Below', 'hellix' ); ?>">
				<span class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'hellix' ); ?></span>
				<div class="d-flex justify-content-between">
					<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'hellix' ) ); ?></div>
					<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'hellix' ) ); ?></div>
				</div>
			</nav><!-- #comment-nav-below -->
			<?php
		endif; // Check for comment navigation.

		if ( ! comments_open() && 0 !== intval( get_comments_number() ) && post_type_supports( get_post_type(), 'comments' ) ) :
			?>
			<div class="alert -warning p-0">
				<div class="alert__content">
					<div class="alert__title text-sm"><?php esc_html_e( 'Comments are closed', 'hellix' ); ?></div>
				</div>
			</div>
			<?php
		endif;
	endif;
	?>

	<div class="mb-4">
		<?php
		$args = array(
			'class_container'    => 'respondForm',
			'class_form'         => 'respondForm__form',
			'title_reply_before' => '<h3 id="reply-title" class="comments-reply-title text-2xl">',
			'title_reply_after'  => '</h3>',
			'comment_field'      => '<div class="col-12 p-0"><textarea name="comment" id="comment" placeholder="' . esc_attr__( 'Your Comment', 'hellix' ) . '" rows="5"></textarea></div>',
			'class_submit'       => 'button -md -accent text-white',
			'submit_button'      => '<button type="submit" name="%1$s" id="%2$s" class="%3$s">%4$s</button>',
		);

		comment_form( $args );
		?>
	</div>

</div><!-- #comments -->
