<?php
/**
 * Hellix engine room
 *
 * @package hellix
 */

/**
 * Assign the Hellix version to a var
 */
$theme          = wp_get_theme( 'hellix' );
$hellix_version = $theme['Version'];

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 980; /* pixels */
}

$hellix = (object) array(
	'version'    => $hellix_version,
	'main'       => require get_template_directory() . '/inc/class-hellix.php',
	'customizer' => require get_template_directory() . '/inc/customizer/class-hellix-customizer.php',
);

/**
 * Social Share
 */
require get_template_directory() . '/inc/classes/class-hellix-socialshare.php';

require get_template_directory() . '/inc/hellix-functions.php';
require get_template_directory() . '/inc/hellix-template-hooks.php';
require get_template_directory() . '/inc/hellix-template-functions.php';
require get_template_directory() . '/inc/customizer/hellix-customizer-functions.php';

/**
 * Include Walker File.
 */
require get_template_directory() . '/inc/walker.php';
require get_template_directory() . '/inc/topbar-walker.php';

/**
 * ACF Integration
 */
require get_template_directory() . '/inc/acf/hellix-acf-functions.php'; // This should not be placed inside the acf_activated check because of fallback function.
if ( hellix_is_acf_activated() ) {
	$hellix->acf = require get_template_directory() . '/inc/acf/class-hellix-acf.php';
	require get_template_directory() . '/inc/acf/hellix-acf-hooks.php';
}

if ( is_admin() ) {
	$hellix->admin = require get_template_directory() . '/inc/admin/class-hellix-admin.php';

	/**
	 * TGM Plugin Activation class.
	 */
	require get_template_directory() . '/inc/classes/class-tgm-plugin-activation.php';
	$hellix->plugin_install = require get_template_directory() . '/inc/admin/class-hellix-plugin-install.php';

	if ( hellix_is_ocdi_activated() ) {
		$hellix->ocdi = require get_template_directory() . '/inc/ocdi/class-hellix-ocdi.php';
	}
}

if ( hellix_is_woocommerce_activated() ) {
	$hellix->woocommerce            = require get_template_directory() . '/inc/woocommerce/class-hellix-woocommerce.php';
	$hellix->woocommerce_customizer = require get_template_directory() . '/inc/woocommerce/class-hellix-woocommerce-customizer.php';

	require get_template_directory() . '/inc/woocommerce/hellix-woocommerce-template-hooks.php';
	require get_template_directory() . '/inc/woocommerce/hellix-woocommerce-template-functions.php';
	require get_template_directory() . '/inc/woocommerce/hellix-woocommerce-functions.php';
	require get_template_directory() . '/inc/woocommerce/hellix-wc-template-functions-overrides.php';
	require get_template_directory() . '/inc/woocommerce/integrations.php';
	require get_template_directory() . '/inc/wpforms/integration.php';
}


add_post_type_support( 'jetpack-portfolio', 'thumbnail' );

