<?php
/**
 * Hellix ACF functions
 *
 * @package  hellix
 */

if ( ! function_exists( 'hellix_get_field' ) ) {
	/**
	 * Wrapper for ACF's get_field function.
	 *
	 * @param string   $field custom field key.
	 * @param int|bool $post_id ID of the post.
	 * @param bool     $format_value should format the meta value or not.
	 * @return mixed
	 */
	function hellix_get_field( $field, $post_id = false, $format_value = true ) {
		if ( function_exists( 'get_field' ) ) {
			return get_field( $field, $post_id, $format_value );
		}

		return false;
	}
}

/**
 * Get term field
 *
 * @param string $field_name The meta field name.
 * @param string $taxonomy_name taxonamy key.
 * @param int    $term_id taxonamy ID.
 * @return mixed
 */
function hellix_acf_get_term_field( $field_name, $taxonomy_name, $term_id ) {

	$value = hellix_get_field( $field_name, $taxonomy_name . '_' . $term_id );

	return $value;
}

/**
 * Page header subtitle
 */
function hellix_page_subtitle() {

	$value = hellix_get_field( 'masthead__subtitle' );

	return $value;
}

/**
 * Page Product category.
 *
 * @param string $term the sidebar term.
 */
function hellix_product_category( $term ) {

	$value = hellix_get_field( 'layout__select', $term );

	return $value;
}

/**
 * Get the product column for the term.
 */
function hellix_acf_product_cat_column() {
	$term = get_queried_object();

	if ( hellix_is_woocommerce_activated() && is_product_category() ) {
		$column = hellix_get_field( 'column', $term );
	}

	return $column;
}

/**
 * Set Product Category columns
 *
 * @param string $columns Products per row.
 * @return string
 */
function hellix_acf_get_product_cat_column( $columns ) {
	if ( hellix_is_woocommerce_activated() && is_product_category() ) {
		$columns = hellix_acf_product_cat_column();
	}

	return $columns;
}

if ( ! function_exists( 'hellix_get_category_layout' ) ) {
	/**
	 * Returns the version of the footer for the website.
	 *
	 * @return string
	 */
	function hellix_get_category_layout() {
		$term                    = get_queried_object();
		$hellix_product_category = hellix_product_category( $term );

		$layout = get_theme_mod( 'product_archive_layout', 'left-sidebar' );

		if ( $hellix_product_category && 'default' !== $hellix_product_category ) {
			$layout = $hellix_product_category;
		}

		return $layout;

	}
}


/**
 * Page header title
 */
function hellix_page_title() {

	$value = hellix_get_field( 'masthead__title' );

	$title = empty( $value ) ? get_the_title() : $value;

	return $title;
}

if ( ! function_exists( 'hellix_acf_portfolio_tag' ) ) {
	/**
	 * Replace the background of the main category.
	 *
	 * @param string $type Portfolio type.
	 * @return string
	 */
	function hellix_acf_portfolio_tag( $type ) {
		$term = get_field( 'portfolio_main_type' );
		if ( $term ) {
			$type = $term->name;
		}
		return $type;
	}
}


require get_template_directory() . '/inc/acf/portfolio.php';

