<?php
/**
 * Hellix Theme Customizer
 *
 * @package hellix
 */

/**
 * Mas Static block
 */
function hellix_static_content_options() {
	if ( hellix_is_mas_static_content_activated() ) {
		$static_block = array();
		$args         = array(
			'post_type'      => 'mas_static_content',
			'post_status'    => 'publish',
			'limit'          => '-1',
			'posts_per_page' => '-1',
		);

		$static_blocks = get_posts( $args );

		if ( ! empty( $static_blocks ) ) {
			$options = array( '' => esc_html__( '— Select —', 'hellix' ) );
			foreach ( $static_blocks as $static_block ) {
				$options[ $static_block->ID ] = $static_block->post_title;
			}
		} else {
			$options = array( '' => esc_html__( 'No Static Content Found', 'hellix' ) );
		}

		return $options;
	}
}
