<?php
/**
 * Hellix template functions.
 *
 * @package hellix
 */
require get_template_directory() . '/inc/template-functions/global.php';
require get_template_directory() . '/inc/template-functions/blog.php';
require get_template_directory() . '/inc/template-functions/blog-post.php';
require get_template_directory() . '/inc/template-functions/header.php';
require get_template_directory() . '/inc/template-functions/loop-post.php';
require get_template_directory() . '/inc/template-functions/page.php';
require get_template_directory() . '/inc/template-functions/single.php';
require get_template_directory() . '/inc/template-functions/footer.php';
require get_template_directory() . '/inc/template-functions/portfolio.php';
require get_template_directory() . '/inc/template-functions/single-portfolio.php';


if ( ! function_exists( 'replace_reply_link_class' ) ) {
	/**
	 * Function to replace reply link class.
	 *
	 * @param string $class css class.
	 */
	function replace_reply_link_class( $class ) {
		$class = str_replace( "class='comment-reply-link", "class='comment-reply-link button -underline text-accent", $class );
		return $class;
	}
}

if ( ! function_exists( 'replace_edit_link_class' ) ) {
	/**
	 * Function to replace edit link class.
	 *
	 * @param string $class css class.
	 */
	function replace_edit_link_class( $class ) {
		$class = str_replace( 'class="comment-edit-link', 'class="comment-edit-link button -underline', $class );
		return $class;
	}
}

if ( ! function_exists( 'hellix_cancel_comment_reply_link' ) ) {
	/**
	 * Function to replace the cancel reply link class.
	 *
	 * @param string $link The link HTML.
	 * @return string
	 */
	function hellix_cancel_comment_reply_link( $link ) {
		$link = str_replace( 'id="cancel-comment-reply-link"', 'id="cancel-comment-reply-link" class="text-accent"', $link );
		return $link;
	}
}
