<?php
/**
 * Template functions related to Single Post.
 */

if ( ! function_exists( 'hellix_single_post_header' ) ) {
	/**
	 * Display the single post header.
	 *
	 * @since 1.0.0
	 */
	function hellix_single_post_header() {
		?><div class="pb-4" style="max-width:38rem">
		<?php
			hellix_breadcrumb();
			the_title( '<h1 class="post-title pt-1 mt-2">', '</h1>' );
		?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_single_post_meta' ) ) {
	/**
	 * Display the single post meta.
	 *
	 * @since 1.0.0
	 */
	function hellix_single_post_meta() {
		?>
		<div class="row position-relative no-gutters align-items-center border-top border-bottom mb-4 hellix-post-author-and-sharing">
			<div class="py-3 pr-md-3 hellix-post-author">
				<div class="d-flex align-items-center justify-content-center justify-content-md-start">
					<div class="media media-ie-fix align-items-center mr-grid-gutter">
						<a class="d-block" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
							<?php echo get_avatar( get_the_author_meta( 'user_email' ), 64, '', '', array( 'class' => 'rounded-circle mr-1' ) ); ?>
						</a>
						<div class="media-body pl-2">
							<h6 class="nav-heading mb-1"><a href="#"><?php echo esc_url( get_the_author_meta( 'display_name' ) ); ?></a></h6>
							<div class="text-nowrap">
								<?php
								// Posted on.
								$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

								if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
									$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
								}

								$time_string = sprintf(
									$time_string,
									esc_attr( get_the_date( 'c' ) ),
									esc_html( get_the_date() ),
									esc_attr( get_the_modified_date( 'c' ) ),
									esc_html( get_the_modified_date() )
								);

								$output_time_string = sprintf( '<a href="%1$s" rel="bookmark" class="text-decoration-none text-reset">%2$s</a>', esc_url( get_permalink() ), $time_string );

								?>
								<div class="meta-link font-size-xs">
									<i class="fe-calendar mr-1 mt-n1"></i>&nbsp;
									<?php
									echo wp_kses(
										$output_time_string,
										array(
											'a'    => array(
												'href'  => array(),
												'title' => array(),
												'rel'   => array(),
												'class' => array(),
											),
											'time' => array(
												'datetime' => array(),
												'class'    => array(),
											),
										)
									);
									?>
								</div>
								<?php if ( ! post_password_required() && ( comments_open() || 0 !== intval( get_comments_number() ) ) ) : ?>
								<span class="meta-divider"></span>
								<a class="meta-link font-size-xs" href="<?php echo esc_url( get_comments_link() ); ?>" data-scroll>
									<i class="fe-message-square mr-1"></i>&nbsp;<?php echo esc_html( get_comments_number() ); ?>
								</a>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<?php if ( class_exists( 'Hellix_SocialShare' ) && apply_filters( 'hellix_social_share', true ) ) : ?>
				<div class="pl-md-3 post-share">
					<div class="d-flex align-items-center justify-content-center justify-content-md-end">
						<?php hellix_share_display(); ?>
					</div>
				</div>
			<?php endif; ?>		
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_single_post_content' ) ) :
	/**
	 * Display the page content
	 *
	 * @since 1.0.0
	 */
	function hellix_single_post_content() {
		?>
		<div class="article__content article__content--post pt-3 mb-5 font-size-md">
		<?php

			/**
			 * Functions hooked in to hellix_post_content_before action.
			 */
			do_action( 'hellix_post_content_before' );
		?>

			<div class="post__content single_post__content">
				<?php the_content(); ?>
			</div>


			<?php
				$link_pages = wp_link_pages(
					array(
						'before'      => '<div class="page-links"><span class="d-block text-dark mb-3">' . esc_html__( 'Pages:', 'hellix' ) . '</span><nav class="pagination mb-0">',
						'after'       => '</nav></div>',
						'link_before' => '<span class="page-link">',
						'link_after'  => '</span>',
						'echo'        => 0,
					)
				);
				$link_pages = str_replace( 'post-page-numbers', 'post-page-numbers page-item', $link_pages );
				$link_pages = str_replace( 'current', 'current active', $link_pages );
				echo wp_kses_post( $link_pages );

			?>
		</div><!-- .entry-content -->
		<?php
	}
endif;

if ( ! function_exists( 'hellix_comment_form_default_fields' ) ) {
	/**
	 * Display the comment form default fields.
	 *
	 * @since 1.0.0
	 * @param string $fields display email, author, cookies etc.
	 */
	function hellix_comment_form_default_fields( $fields ) {
		$req       = get_option( 'require_name_email' );
		$html5     = true;
		$commenter = wp_get_current_commenter();

		// Define attributes in HTML5 or XHTML syntax.
		$required_attribute = ( $html5 ? ' required' : ' required="required"' );
		$checked_attribute  = ( $html5 ? ' checked' : ' checked="checked"' );

		// Identify required fields visually.
		$required_indicator = ' <span class="required" aria-hidden="true">*</span>';

		$new_fields = array(
			'author' => sprintf(
				'<p class="comment-form-author col-6 pl-0">%s %s</p>',
				sprintf(
					'<label class="sr-only" for="author">%s%s</label>',
					esc_html__( 'Name', 'hellix' ),
					( $req ? $required_indicator : '' )
				),
				sprintf(
					'<input id="author" placeholder="' . esc_attr__( 'Name', 'hellix' ) . ' %s"  name="author" type="text" value="%s" size="30" maxlength="245"%s />',
					( $req ? '*' : '' ),
					esc_attr( $commenter['comment_author'] ),
					( $req ? $required_attribute : '' )
				)
			),
			'email'  => sprintf(
				'<p class="comment-form-email col-6 pr-0">%s %s</p>',
				sprintf(
					'<label class="sr-only" for="email">%s%s</label>',
					esc_html__( 'Email', 'hellix' ),
					( $req ? $required_indicator : '' )
				),
				sprintf(
					'<input id="email" placeholder="' . esc_attr__( 'Email', 'hellix' ) . ' %s" name="email" %s value="%s" size="30" maxlength="100" aria-describedby="email-notes"%s />',
					( $req ? '*' : '' ),
					( $html5 ? 'type="email"' : 'type="text"' ),
					esc_attr( $commenter['comment_author_email'] ),
					( $req ? $required_attribute : '' )
				)
			),
			'url'    => sprintf(
				'<p class="comment-form-url col-12 p-0">%s %s</p>',
				sprintf(
					'<label class="sr-only" for="url">%s</label>',
					esc_html__( 'Website', 'hellix' )
				),
				sprintf(
					'<input id="url" placeholder="' . esc_attr__( 'Website', 'hellix' ) . ' %s"  name="url" %s value="%s" size="30" maxlength="200" />',
					( $req ? '*' : '' ),
					( $html5 ? 'type="url"' : 'type="text"' ),
					esc_attr( $commenter['comment_author_url'] )
				)
			),
		);

		foreach ( $new_fields as $key => $new_field ) {
			if ( isset( $fields[ $key ] ) && isset( $new_fields[ $key ] ) ) {
				$fields[ $key ] = $new_fields[ $key ];
			}
		}
		return $fields;
	}
}



if ( ! function_exists( 'hellix_single_related_posts' ) ) {
	/**
	 * Display the single related post.
	 *
	 * @since 1.0.0
	 */
	function hellix_single_related_posts() {
		if ( apply_filters( 'hellix_enable_related_posts', filter_var( get_theme_mod( 'blog_related_posts', 'no' ), FILTER_VALIDATE_BOOLEAN ) ) ) {
			if ( empty( $post_id ) ) {
				$post_id = get_the_ID();
			}

			$tags = wp_get_post_terms( $post_id, 'post_tag', [ 'fields' => 'ids' ] );

			if ( empty( $tags ) ) {
				return;
			}

			$related_post = new WP_Query(
				array(
					'post_type'           => 'post',
					'post_status'         => 'publish',
					'ignore_sticky_posts' => 1,
					'orderby'             => 'date',
					'order'               => 'desc',
					'posts_per_page'      => 4,
					'tax_query'           => array(
						array(
							'taxonomy' => 'post_tag',
							'terms'    => $tags,
						),
					),
				)
			);

			$carousel_args = apply_filters(
				'hellix_related_posts_carousel_args',
				array(
					'infinte'    => false,
					'items'      => 4,
					'autoplay'   => false,
					'autoHeight' => true,
					'nav'        => true,
					'controls'   => false,
					'responsive' => array(
						'0'    => array(
							'items'  => 1,
							'gutter' => 16,

						),

						'500'  => array(
							'items'  => 2,
							'gutter' => 16,

						),

						'850'  => array(
							'items'  => 3,
							'gutter' => 16,

						),

						'1100' => array(
							'items'  => 3,
							'gutter' => 23,

						),

					),
				)
			);

			if ( $related_post->have_posts() ) :
				?>
				<div class="pb-4 pb-md-5">
					<h2 class="h3 pb-4"><?php echo esc_html( apply_filters( 'hellix_related_post_heading', esc_html__( 'Related posts', 'hellix' ) ) ); ?></h2>  

					<div class="cs-carousel">
						<div class="products-carousel-wrap cs-carousel-inner related-post-carousel" data-carousel-options="<?php echo esc_attr( json_encode( $carousel_args ), ENT_QUOTES, 'UTF-8' ); ?>">
							<?php
							while ( $related_post->have_posts() ) :
								$related_post->the_post();
								get_template_part( 'templates/blog/loop', 'related' );
							endwhile;
							wp_reset_postdata();
							?>
						</div>
					</div>
				</div>
				<?php
			endif;
		}
	}
}
