<?php
/**
 * Template functions for Page.
 *
 * @package hellix
 */

if ( ! function_exists( 'hellix_page_masthead' ) ) {
	/**
	 * Display page masthead.
	 */
	function hellix_page_masthead() {
		hellix_output_page_masthead();
	}
}

if ( ! function_exists( 'hellix_page_content' ) ) {
	/**
	 * Page content
	 */
	function hellix_page_content() {
		$is_prose_enabled   = apply_filters( 'hellix_is_page_prose_enabled', true );
		$page_content_class = '';
		if ( hellix_is_extensions_activated() ) {
			$page_content_class .= ' max-w-none';
		} else {
			$page_content_class .= ' max-w-[75%] mx-auto';
		}

		if ( $is_prose_enabled ) {
			$page_content_class .= ' prose';
		} else {
			$page_content_class .= ' not-prose';
		}
		?>
		<div class="entry-content">
			<div class="flex flex-col">
				<div class="<?php echo esc_attr( $page_content_class ); ?>">
					<?php
						the_content();
						hellix_link_pages();
					?>
				</div>
			</div>
		</div><!-- .entry-content -->
		<?php
	}
}

if ( ! function_exists( 'hellix_search_post_type_name' ) ) {
	/**
	 * Returns the registered name for a post type
	 *
	 * This function was designed to use on a search results page.
	 *
	 * @param string $post_type Post type.
	 *
	 * @return string
	 */
	function hellix_search_post_type_name( $post_type ) {
		$post_type_name = '';

		if ( ! empty( $post_type ) ) {
			$post_type_obj = get_post_type_object( $post_type );
			if ( ! empty( $post_type_obj ) ) {
				$post_type_name = $post_type_obj->name;
			}
		}
		return $post_type_name;
	}
}
