<?php
/**
 * Hellix WooCommerce Customizer Class
 *
 * @package  hellix
 * @since    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Hellix_WooCommerce_Customizer' ) ) :

	/**
	 * The hellix Customizer class
	 */
	class Hellix_WooCommerce_Customizer extends Hellix_Customizer {

		/**
		 * Setup class.
		 *
		 * @since 1.0.0
		 * @return void
		 */
		public function __construct() {
			add_action( 'customize_register', array( $this, 'customize_shop_settings' ), 10 );
		}

		/**
		 * Add postMessage support for site title and description for the Theme Customizer along with several other settings.
		 *
		 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
		 * @since 1.0.0
		 */
		public function customize_shop_settings( $wp_customize ) {
			$this->static_contents = hellix_static_content_options();
			/**
			 * Shop page
			 */

			global $hellix;

			$wp_customize->add_section(
				'hellix_shop',
				array(
					'title'       => esc_html__( 'Shop Page', 'hellix' ),
					'description' => esc_html__( 'This section contains settings related to products listing and archives.', 'hellix' ),
					'priority'    => 30,
					'panel'       => 'woocommerce',
				)
			);

			$wp_customize->add_setting(
				'product_archive_layout',
				array(
					'default'           => 'left-sidebar',
					'capability'        => 'edit_theme_options',
					'sanitize_callback' => 'sanitize_key',
					'transport'         => 'postMessage',
				)
			);

			$wp_customize->add_control(
				'product_archive_layout',
				array(
					'type'        => 'select',
					'section'     => 'hellix_shop',
					/* translators: label field of control in Customizer */
					'label'       => esc_html__( 'Shop Sidebar', 'hellix' ),
					'description' => esc_html__( 'Select from the three sidebar layouts for shop', 'hellix' ),
					'choices'     => [
						'left-sidebar'  => esc_html__( 'Left Sidebar', 'hellix' ),
						'right-sidebar' => esc_html__( 'Right Sidebar', 'hellix' ),
						'full-width'    => esc_html__( 'Full Width', 'hellix' ),
					],
					'priority'    => 10,
				)
			);

			$wp_customize->selective_refresh->add_partial(
				'shop_header_image',
				[
					'fallback_refresh' => true,
				]
			);

			$wp_customize->add_setting(
				'shop_header_image',
				array(
					'transport'         => 'postMessage',
					'sanitize_callback' => 'absint',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Media_Control(
					$wp_customize,
					'shop_header_image',
					array(
						'section'     => 'hellix_shop',
						'label'       => esc_html__( 'Page Header Image', 'hellix' ),
						'description' => esc_html__(
							'This setting allows you to upload an image for shop page header.',
							'hellix'
						),
						'mime_type'   => 'image',
						'priority'    => 20,
					)
				)
			);

			$wp_customize->add_setting(
				'header_title',
				[
					'default'           => esc_html_x( 'Shop', 'front-end', 'hellix' ),
					'sanitize_callback' => 'sanitize_text_field',
					'transport'         => 'postMessage',
				]
			);

			$wp_customize->add_control(
				'header_title',
				[
					'type'     => 'text',
					'section'  => 'hellix_shop',
					'label'    => esc_html__( 'Header Title', 'hellix' ),
					'priority' => 30,
				]
			);

			$wp_customize->add_setting(
				'header_subtitle',
				[
					'default'           => esc_html_x( 'Products', 'front-end', 'hellix' ),
					'sanitize_callback' => 'sanitize_text_field',
					'transport'         => 'postMessage',
				]
			);

			$wp_customize->add_control(
				'header_subtitle',
				[
					'type'     => 'text',
					'section'  => 'hellix_shop',
					'label'    => esc_html__( 'Header SubTitle', 'hellix' ),
					'priority' => 40,
				]
			);

		}

	}

endif;

return new Hellix_WooCommerce_Customizer();
