<?php
/**
 * Hellix WooCommerce functions.
 *
 * @package hellix
 */

/**
 * Checks if the current page is a product archive
 *
 * @return boolean
 */
if ( ! function_exists( 'hellix_is_product_archive' ) ) {
	/**
	 * Checks if the current page is a product archive
	 */
	function hellix_is_product_archive() {
		if ( is_shop() || is_product_taxonomy() || is_product_category() || is_product_tag() ) {
			return true;
		} else {
			return false;
		}
	}
}

/**
 * Returns if a sidebar for Shop is available or not
 */
if ( ! function_exists( 'hellix_shop_has_sidebar' ) ) {
	/**
	 * Returns if a sidebar for Shop is available or not
	 */
	function hellix_shop_has_sidebar() {
		$layout = hellix_get_product_archive_layout();

		return 'full-width' !== $layout;
	}
}

/**
 * Returns the sidebar of shop page chosen by user
 */
if ( ! function_exists( 'hellix_get_product_archive_layout' ) ) {
	/**
	 * Returns the sidebar of shop page chosen by user
	 */
	function hellix_get_product_archive_layout() {

		$available_sidebars = array( 'left-sidebar', 'right-sidebar', 'full-width' );
		if ( hellix_is_woocommerce_activated() && ( is_shop() || is_product_category() || is_tax( 'product_label' ) || is_tax( get_object_taxonomies( 'product' ) ) ) ) {
			if ( is_active_sidebar( 'sidebar-shop' ) ) {
				$sidebar = get_theme_mod( 'product_archive_layout', 'left-sidebar' );
			} else {
				$sidebar = 'full-width';
			}
		} else {
			$sidebar = 'left-sidebar';
		}

		if ( ! in_array( $sidebar, $available_sidebars ) ) {
			$sidebar = 'right-sidebar';
		}

		return sanitize_key( apply_filters( 'hellix_shop_sidebar', $sidebar ) );
	}
}

/**
 * Returns the add to cart link
 */
if ( ! function_exists( 'hellix_wc_loop_add_to_cart_link' ) ) {
	/**
	 * Returns the add to cart link
	 *
	 * @param string $cart_link the link for the cart.
	 * @param array  $product the product to be added to cart.
	 * @param int    $args the args to be passed.
	 */
	function hellix_wc_loop_add_to_cart_link( $cart_link, $product, $args ) {
		$cart_svg = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-bag icon"><path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path><line x1="3" y1="6" x2="21" y2="6"></line><path d="M16 10a4 4 0 0 1-8 0"></path></svg>';
			return sprintf(
				'<a data-barba href="%s" data-quantity="%s" class="shopCard__button %s" %s title="%s">%s%s</a>',
				esc_url( $product->add_to_cart_url() ),
				esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
				esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
				isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
				esc_attr( $product->add_to_cart_text() ),
				$cart_svg,
				esc_attr( $product->add_to_cart_text() )
			);
	}
}
