<?php
/**
 * Template functions used in Cart
 */

if ( ! function_exists( 'hellix_cart_link_fragment' ) ) {
	/**
	 * Cart Fragments
	 * Ensure cart contents update when products are added to the cart via AJAX
	 *
	 * @param  array $fragments Fragments to refresh via AJAX.
	 * @return array            Fragments to refresh via AJAX
	 */
	function hellix_cart_link_fragment( $fragments ) {
		global $woocommerce;

		ob_start();
		hellix_wc_offcanvas_mini_cart_content();
		$fragments['div.hellix-minicart1'] = ob_get_clean();

		ob_start();
		hellix_cart_link_count();
		$fragments['span.cart-contents-count'] = ob_get_clean();

		return $fragments;

	}
}
