<?php
/**
 * Template functions used in Product Archive
 */

if ( ! function_exists( 'hellix_wc_result_count' ) ) {
	/**
	 * Template functions used in Product Archive
	 */
	function hellix_wc_result_count() {
		if ( ! wc_get_loop_prop( 'is_paginated' ) || ! woocommerce_products_will_display() ) {
			return;
		}
		$total    = wc_get_loop_prop( 'total' );
		$per_page = wc_get_loop_prop( 'per_page' );
		$current  = wc_get_loop_prop( 'current_page' );
		$first    = ( $per_page * $current ) - $per_page + 1;
		$last     = min( $total, $per_page * $current );
			/* translators: 1: first result 2: last result 3: total results */
			printf( _nx( 'Showing %1$d&ndash;%2$d of %3$d result', 'Showing %1$d&ndash;%2$d of %3$d results', $total, 'with first and last result', 'hellix' ), $first, $last, $total ); // phpcs:ignore
	}
}

/**
 * Outputs all queued notices on WC pages.
 *
 * @since 3.5.0
 */
if ( ! function_exists( 'hellix_shop_control_bar' ) ) {
	/**
	 * Output shop control bar.
	 */
	function hellix_shop_control_bar() {
		?><div class="d-flex justify-content-between">
			<div class="text-sm text-grey"><?php do_action( 'hellix_shop_control_bar_left' ); ?></div>
			<div class="text-sm text-grey"><?php do_action( 'hellix_shop_control_bar_right' ); ?></div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_woocommerce_catalog_ordering' ) ) {

	/**
	 * Output the product sorting options.
	 */
	function hellix_woocommerce_catalog_ordering() {
		if ( ! wc_get_loop_prop( 'is_paginated' ) || ! woocommerce_products_will_display() ) {
			return;
		}
		$show_default_orderby    = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', 'menu_order' ) );
		$catalog_orderby_options = apply_filters(
			'woocommerce_catalog_orderby',
			array(
				'menu_order' => __( 'Default sorting', 'hellix' ),
				'popularity' => __( 'Sort by popularity', 'hellix' ),
				'rating'     => __( 'Sort by average rating', 'hellix' ),
				'date'       => __( 'Sort by latest', 'hellix' ),
				'price'      => __( 'Sort by price: low to high', 'hellix' ),
				'price-desc' => __( 'Sort by price: high to low', 'hellix' ),
			)
		);

		$default_orderby = wc_get_loop_prop( 'is_search' ) ? 'relevance' : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', '' ) );
        // phpcs:disable WordPress.Security.NonceVerification.Recommended
		$orderby = isset( $_GET['orderby'] ) ? wc_clean( wp_unslash( $_GET['orderby'] ) ) : $default_orderby;
        // phpcs:enable WordPress.Security.NonceVerification.Recommended

		if ( wc_get_loop_prop( 'is_search' ) ) {
			$catalog_orderby_options = array_merge( array( 'relevance' => __( 'Relevance', 'hellix' ) ), $catalog_orderby_options );

			unset( $catalog_orderby_options['menu_order'] );
		}

		if ( ! $show_default_orderby ) {
			unset( $catalog_orderby_options['menu_order'] );
		}

		if ( ! wc_review_ratings_enabled() ) {
			unset( $catalog_orderby_options['rating'] );
		}

		if ( ! array_key_exists( $orderby, $catalog_orderby_options ) ) {
			$orderby = current( array_keys( $catalog_orderby_options ) );
		}

		wc_get_template(
			'loop/orderby.php',
			array(
				'catalog_orderby_options' => $catalog_orderby_options,
				'orderby'                 => $orderby,
				'show_default_orderby'    => $show_default_orderby,
			)
		);
	}
}

