<?php
/**
 * Template functions used in Product Loop
 */

if ( ! function_exists( 'hellix_product_loop_wrap_open' ) ) {
	/**
	 * Function to open product loop
	 */
	function hellix_product_loop_wrap_open() {?>
		<div class="shopCard text-center">
		<?php
	}
}

if ( ! function_exists( 'hellix_product_image_wrap_open' ) ) {
	/**
	 * Function to open image wrap
	 */
	function hellix_product_image_wrap_open() {
		?>
		<div class="shopCard__image ratio ratio-29:33">
		<?php
	}
}

if ( ! function_exists( 'hellix_product_image_wrap_close' ) ) {
	/**
	 * Function to close image wrap
	 */
	function hellix_product_image_wrap_close() {
		?>
	</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_product_loop_card_body_open' ) ) {
	/**
	 * Function to open card body
	 */
	function hellix_product_loop_card_body_open() {
		?>
		<div class="shopCard__content mt-20">
			<div class="shopCard__category text-accent">
			<?php
	}
}

if ( ! function_exists( 'hellix_product_loop_wrap_close' ) ) {
	/**
	 * Function to close product wrap
	 */
	function hellix_product_loop_wrap_close() {
		?>
		</div>
		<?php
	}
}


if ( ! function_exists( 'hellix_template_loop_categories' ) ) {
	/**
	 * Function to display categories
	 */
	function hellix_template_loop_categories() {
		global $product;

		$taxonomy = 'product_cat';
		$terms    = get_the_terms( $product->get_id(), $taxonomy );
		if ( empty( $terms ) || is_wp_error( $terms ) ) {
			return;
		}

		$links = [];
		foreach ( $terms as $term ) {
			$link = get_term_link( $term, $taxonomy );
			if ( is_wp_error( $link ) ) {
				continue;
			}

			$links[] = sprintf(
				'<a data-barba href="%s" class="">%s</a>',
				esc_url( $link ),
				esc_html( $term->name )
			);
		}

		echo apply_filters( 'chellix_template_loop_categories_html', implode( ', ', $links ) );// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}

if ( ! function_exists( 'hellix_template_loop_product_title' ) ) {
	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function hellix_template_loop_product_title() {
		echo '<h4 class="' . esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title shopCard__title text-base mt-8' ) ) . '">' . get_the_title() . '</h4>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}


if ( ! function_exists( 'hellix_product_category_close' ) ) {
	/**
	 * Closes the product category product loop.
	 */
	function hellix_product_category_close() {
		?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_product_content_close' ) ) {
	/**
	 * Closes the product content.
	 */
	function hellix_product_content_close() {
		?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_template_loop_product_title' ) ) {
	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function hellix_template_loop_product_title() {
		echo '<h4 class="' . esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title shopCard__title text-base mt-8' ) ) . '">' . get_the_title() . '</h4>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}


if ( ! function_exists( 'hellix_product_category_close' ) ) {
	/**
	 * Closes the product category product loop.
	 */
	function hellix_product_category_close() {
		?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'hellix_product_content_close' ) ) {
	/**
	 * Closes the product content.
	 */
	function hellix_product_content_close() {
		?>
		</div>
		<?php
	}
}

