<?php
/**
 * Template tags used in WC page
 */

if ( ! function_exists( 'hellix_output_cross_sell_products' ) ) {
	/**
	 * Function to output cross sell products.
	 */
	function hellix_output_cross_sell_products() {
		if ( apply_filters( 'hellix_enable_cross_sell_products', true ) ) {
			woocommerce_cross_sell_display( 4, 3 );
		}
	}
}

if ( ! function_exists( 'hellix_wc_checkout_fields' ) ) {
	/**
	 * Modify other checkout fields, like account, order, etc.
	 *
	 * @param array $fields to checkout fields.
	 *
	 * @return array
	 *
	 * @since 1.0.0
	 */
	function hellix_wc_checkout_fields( $fields ) {
		if ( ! empty( $fields['account'] ) ) {
			if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) {
				$fields['account']['account_username']['class']       = [ 'form-group', 'col-sm-12' ];
				$fields['account']['account_username']['input_class'] = [ 'form-control' ];
			}

			if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) {
				$fields['account']['account_password']['class']       = [ 'form-group', 'col-sm-12' ];
				$fields['account']['account_password']['input_class'] = [ 'form-control' ];
			}
		}
		 return $fields;

	}
}

if ( ! function_exists( 'hellix_wc_checkout_address_fields' ) ) {
	 /**
	  * Modify other checkout fields, like account, order, etc.
	  *
	  * @param array $fields to checkout fields.
	  *
	  * @return array
	  *
	  * @since 1.0.0
	  */
	function hellix_wc_checkout_address_fields( $fields ) {
		foreach ( $fields as $field => &$args ) {
			switch ( $field ) {
				case 'first_name':
					$args['class']       = [ 'col-sm-6' ];
					$args['input_class'] = [ 'form-control py-8' ];
					$args['label_class'] = [ 'form-label' ];
					break;
				case 'last_name':
					$args['class']       = [ 'col-sm-6' ];
					$args['input_class'] = [ 'form-control py-8' ];
					$args['label_class'] = [ 'form-label' ];
					break;
				case 'company':
					$args['class']       = [ 'col-sm-12' ];
					$args['input_class'] = [ 'form-control py-8' ];
					$args['label_class'] = [ 'form-label' ];
					break;
				case 'billing_phone':
					$args['class']       = [ 'col-sm-6' ];
					$args['input_class'] = [ 'form-control py-8' ];
					$args['label_class'] = [ 'form-label' ];
					break;

				case 'country':
					$args['class']       = [ 'col-sm-12', 'address-field', 'update_totals_on_change' ];
					$args['input_class'] = [ 'form-control py-8' ];
					$args['label_class'] = [ 'form-label' ];
					break;

				case 'address_1':
				case 'address_2':
					$args['class']       = [ 'col-sm-12', 'address-field' ];
					$args['input_class'] = [ 'form-control py-8' ];
					$args['label_class'] = [ 'form-label' ];
					break;

				case 'city':
				case 'state':
				case 'postcode':
					$args['class']       = [ 'col-sm-6', 'address-field' ];
					$args['input_class'] = [ 'form-control py-8' ];
					$args['label_class'] = [ 'form-label' ];
					break;
				case 'billing_email':
					$args['class']       = [ 'form-group', 'col-sm-12' ];
					$args['input_class'] = [ 'form-control py-8' ];
					$args['label_class'] = [ 'form-label' ];
					break;
			}
		}

		return $fields;
	}
}
